package org.mule.commons.atlantic.lambda.runnable;

import org.mule.commons.atlantic.lambda.AtlanticLambda;
import org.mule.commons.atlantic.lambda.supplier.Supplier;

/**
 * Represents a block of code to be executed.
 */
@FunctionalInterface
public interface Runnable extends AtlanticLambda {

    /**
     * Runs the block of code.
     *
     * @throws Throwable Any exception that the operation will throw.
     */
    void run() throws Throwable;

    /**
     * Converts this into a {@link Supplier} that always returns null.
     *
     * @return Supplier Typed with {@link Void}, this will execute this runnable and return null.
     */
    default Supplier<Void> toSupplier() {
        return () -> {
            run();
            return null;
        };
    }
}
