package org.mule.commons.atlantic;

import org.mule.commons.atlantic.execution.builder.factory.InstanceExecutionBuilderFactory;
import org.mule.commons.atlantic.execution.builder.factory.StaticExecutionBuilderFactory;

/**
 * Main class.
 * This class contains the starter methods to execute both instance methods and static methods/constructors.
 * The first type will require a created object to work, while the second one will not.
 * Normally, regular instance method calls will use the {@link Atlantic#newInstanceExecutionBuilder(Object)} method and
 * both static method calls and  constructor calls will use the {@link Atlantic#newStaticExecutionBuilder()} one.
 * It is possible to use instance methods on using the static executor by setting the instance to be executed as the
 * first parameter but it's not recommended.
 * This class cannot and should not be extended and only provides the 2 static methods for building executions.
 */
public final class Atlantic {

    /**
     * Private constructor. Ensures that the class cannot be instantiated.
     */
    private Atlantic() {
        // Do nothing.
    }

    /**
     * Creates an {@link InstanceExecutionBuilderFactory instance executor}. The executor requires an instance to run over and will call
     * any method defined on it as long as the scope of the execution is allowed (i.e. private method calls will not be
     * allowed out of the class).
     * Static methods or constructors should not be called using this method.
     *
     * @param instance   The instance over which the method will be called.
     * @param <INSTANCE> The type of the instance over which the method will be called.
     * @param <RESULT>   The type of result returned by the execution to build.
     * @return InstanceExecutionBuilderFactory The executor that handles instance method calls.
     */
    public static <INSTANCE, RESULT> InstanceExecutionBuilderFactory<INSTANCE, RESULT> newInstanceExecutionBuilder(INSTANCE instance) {
        return new InstanceExecutionBuilderFactory<>(instance);
    }

    /**
     * Creates a {@link StaticExecutionBuilderFactory static executor}. The executor doesn't require an instance to run over and will
     * call any method defined over it.
     * Only static methods and constructors should be called using this method.
     *
     * @param <RESULT> The type of result returned by the execution to build.
     * @return StaticExecutionBuilderFactory The executor that handles static method calls and constructors.
     */
    public static <RESULT> StaticExecutionBuilderFactory<RESULT> newStaticExecutionBuilder() {
        return new StaticExecutionBuilderFactory<>();
    }
}
