package org.mule.commons.atlantic.execution.builder;

import org.mule.commons.atlantic.execution.context.ExecutionContext;
import org.mule.commons.atlantic.lambda.function.BiFunction;
import org.mule.commons.atlantic.lambda.function.Function;

import java.util.List;

/**
 * {@link GenericFunctionExecutionBuilder} for {@link BiFunction} instances.
 *
 * @param <A>      The first parameter.
 * @param <B>      The second parameter.
 * @param <RESULT> The type of the result of the {@link BiFunction}
 */
public class BiFunctionExecutionBuilder<A, B, RESULT> extends GenericFunctionExecutionBuilder<A, BiFunction<A, B, RESULT>, Function<B, RESULT>, FunctionExecutionBuilder<B, RESULT>, RESULT> {

    /**
     * Default constructor.
     *
     * @param lambda  The {@link BiFunction} to execute.
     * @param params  The parameters already accumulated when creating this ExecutionBuilder.
     * @param context The {@link ExecutionContext} that contains all the listeners and handlers of the execution.
     */
    public BiFunctionExecutionBuilder(BiFunction<A, B, RESULT> lambda, List<Object> params, ExecutionContext context) {
        super(lambda, params, context, FunctionExecutionBuilder::new);
    }
}
