package org.mule.commons.atlantic.execution.builder;

import org.mule.commons.atlantic.execution.context.ExecutionContext;
import org.mule.commons.atlantic.lambda.function.DecaFunction;
import org.mule.commons.atlantic.lambda.function.HendecaFunction;

import java.util.List;

/**
 * {@link GenericFunctionExecutionBuilder} for {@link HendecaFunction} instances.
 *
 * @param <A>      The first parameter.
 * @param <B>      The second parameter.
 * @param <C>      The third parameter.
 * @param <D>      The fourth parameter.
 * @param <E>      The fifth parameter.
 * @param <F>      The sixth parameter.
 * @param <G>      The seventh parameter.
 * @param <H>      The eigth parameter.
 * @param <I>      The ninth parameter.
 * @param <J>      The tenth parameter.
 * @param <K>      The elventh parameter.
 * @param <RESULT> The type of the result of the {@link HendecaFunction}
 */
public class HendecaFunctionExecutionBuilder<A, B, C, D, E, F, G, H, I, J, K, RESULT> extends GenericFunctionExecutionBuilder<A, HendecaFunction<A, B, C, D, E, F, G, H, I, J, K, RESULT>, DecaFunction<B, C, D, E, F, G, H, I, J, K, RESULT>, DecaFunctionExecutionBuilder<B, C, D, E, F, G, H, I, J, K, RESULT>, RESULT> {

    /**
     * Default constructor.
     *
     * @param lambda  The {@link HendecaFunction} to execute.
     * @param params  The parameters already accumulated when creating this ExecutionBuilder.
     * @param context The {@link ExecutionContext} that contains all the listeners and handlers of the execution.
     */
    public HendecaFunctionExecutionBuilder(HendecaFunction<A, B, C, D, E, F, G, H, I, J, K, RESULT> lambda, List<Object> params, ExecutionContext context) {
        super(lambda, params, context, DecaFunctionExecutionBuilder::new);
    }
}
