package org.mule.commons.atlantic.execution.builder;

import org.mule.commons.atlantic.execution.context.ExecutionContext;
import org.mule.commons.atlantic.lambda.function.HeptaFunction;
import org.mule.commons.atlantic.lambda.function.HexaFunction;

import java.util.List;

/**
 * {@link GenericFunctionExecutionBuilder} for {@link HeptaFunction} instances.
 *
 * @param <A>      The first parameter.
 * @param <B>      The second parameter.
 * @param <C>      The third parameter.
 * @param <D>      The fourth parameter.
 * @param <E>      The fifth parameter.
 * @param <F>      The sixth parameter.
 * @param <G>      The seventh parameter.
 * @param <RESULT> The type of the result of the {@link HeptaFunction}
 */
public class HeptaFunctionExecutionBuilder<A, B, C, D, E, F, G, RESULT> extends GenericFunctionExecutionBuilder<A, HeptaFunction<A, B, C, D, E, F, G, RESULT>, HexaFunction<B, C, D, E, F, G, RESULT>, HexaFunctionExecutionBuilder<B, C, D, E, F, G, RESULT>, RESULT> {

    /**
     * Default constructor.
     *
     * @param lambda  The {@link HeptaFunction} to execute.
     * @param params  The parameters already accumulated when creating this ExecutionBuilder.
     * @param context The {@link ExecutionContext} that contains all the listeners and handlers of the execution.
     */
    public HeptaFunctionExecutionBuilder(HeptaFunction<A, B, C, D, E, F, G, RESULT> lambda, List<Object> params, ExecutionContext context) {
        super(lambda, params, context, HexaFunctionExecutionBuilder::new);
    }
}
