package org.mule.commons.atlantic.execution.builder;

import org.mule.commons.atlantic.execution.context.ExecutionContext;
import org.mule.commons.atlantic.lambda.function.DecaFunction;
import org.mule.commons.atlantic.lambda.function.NonaFunction;
import org.mule.commons.atlantic.lambda.function.OctaFunction;

import java.util.List;

/**
 * {@link GenericFunctionExecutionBuilder} for {@link NonaFunction} instances.
 *
 * @param <A>      The first parameter.
 * @param <B>      The second parameter.
 * @param <C>      The third parameter.
 * @param <D>      The fourth parameter.
 * @param <E>      The fifth parameter.
 * @param <F>      The sixth parameter.
 * @param <G>      The seventh parameter.
 * @param <H>      The eigth parameter.
 * @param <I>      The ninth parameter.
 * @param <RESULT> The type of the result of the {@link NonaFunction}
 */
public class NonaFunctionExecutionBuilder<A, B, C, D, E, F, G, H, I, RESULT> extends GenericFunctionExecutionBuilder<A, NonaFunction<A, B, C, D, E, F, G, H, I, RESULT>, OctaFunction<B, C, D, E, F, G, H, I, RESULT>, OctaFunctionExecutionBuilder<B, C, D, E, F, G, H, I, RESULT>, RESULT> {

    /**
     * Default constructor.
     *
     * @param lambda  The {@link DecaFunction} to execute.
     * @param params  The parameters already accumulated when creating this ExecutionBuilder.
     * @param context The {@link ExecutionContext} that contains all the listeners and handlers of the execution.
     */
    public NonaFunctionExecutionBuilder(NonaFunction<A, B, C, D, E, F, G, H, I, RESULT> lambda, List<Object> params, ExecutionContext context) {
        super(lambda, params, context, OctaFunctionExecutionBuilder::new);
    }
}
