package org.mule.commons.atlantic.execution.builder;

import org.mule.commons.atlantic.execution.context.ExecutionContext;
import org.mule.commons.atlantic.lambda.function.Function;
import org.mule.commons.atlantic.lambda.supplier.Supplier;

import java.util.List;

/**
 * Final {@link ExecutionBuilder} that executes the {@link org.mule.commons.atlantic.lambda.AtlanticLambda} that is
 * being built.
 *
 * @param <RESULT> The type of the result of the {@link Function}
 */
public class SupplierExecutionBuilder<RESULT> extends ExecutionBuilder<Supplier<RESULT>, RESULT> {

    /**
     * Default constructor.
     *
     * @param lambda       The {@link Supplier} to execute.
     * @param params       The parameters already accumulated when creating this ExecutionBuilder.
     * @param context      The {@link ExecutionContext} that contains all the listeners and handlers of the execution.
     */
    public SupplierExecutionBuilder(Supplier<RESULT> lambda, List<Object> params, ExecutionContext context) {
        super(lambda, params, context);
    }

    /**
     * Runs the {@link org.mule.commons.atlantic.execution.context.executor.Executor} set in the {@link ExecutionContext}
     * {@link org.mule.commons.atlantic.lambda.AtlanticLambda}
     * thet is being built using the framework, the accumulated parameters and the {@link ExecutionContext}.
     *
     * @return Object The result of the execution call.
     */
    public RESULT execute() {
        return getContext().execute(getLambda(), getParams());
    }
}
