package org.mule.commons.atlantic.execution.builder;

import org.mule.commons.atlantic.execution.context.ExecutionContext;
import org.mule.commons.atlantic.lambda.function.TetraFunction;
import org.mule.commons.atlantic.lambda.function.TriFunction;

import java.util.List;

/**
 * {@link GenericFunctionExecutionBuilder} for {@link TetraFunction} instances.
 *
 * @param <A>      The first parameter.
 * @param <B>      The second parameter.
 * @param <C>      The third parameter.
 * @param <D>      The fourth parameter.
 * @param <RESULT> The type of the result of the {@link TetraFunction}
 */
public class TetraFunctionExecutionBuilder<A, B, C, D, RESULT> extends GenericFunctionExecutionBuilder<A, TetraFunction<A, B, C, D, RESULT>, TriFunction<B, C, D, RESULT>, TriFunctionExecutionBuilder<B, C, D, RESULT>, RESULT> {

    /**
     * Default constructor.
     *
     * @param lambda  The {@link TetraFunction} to execute.
     * @param params  The parameters already accumulated when creating this ExecutionBuilder.
     * @param context The {@link ExecutionContext} that contains all the listeners and handlers of the execution.
     */
    public TetraFunctionExecutionBuilder(TetraFunction<A, B, C, D, RESULT> lambda, List<Object> params, ExecutionContext context) {
        super(lambda, params, context, TriFunctionExecutionBuilder::new);
    }
}
