package org.mule.commons.atlantic.execution.builder;

import org.mule.commons.atlantic.execution.context.ExecutionContext;
import org.mule.commons.atlantic.lambda.function.BiFunction;
import org.mule.commons.atlantic.lambda.function.TriFunction;

import java.util.List;

/**
 * {@link GenericFunctionExecutionBuilder} for {@link TriFunction} instances.
 *
 * @param <A>      The first parameter.
 * @param <B>      The second parameter.
 * @param <C>      The third parameter.
 * @param <RESULT> The type of the result of the {@link TriFunction}
 */
public class TriFunctionExecutionBuilder<A, B, C, RESULT> extends GenericFunctionExecutionBuilder<A, TriFunction<A, B, C, RESULT>, BiFunction<B, C, RESULT>, BiFunctionExecutionBuilder<B, C, RESULT>, RESULT> {

    /**
     * Default constructor.
     *
     * @param lambda  The {@link TriFunction} to execute.
     * @param params  The parameters already accumulated when creating this ExecutionBuilder.
     * @param context The {@link ExecutionContext} that contains all the listeners and handlers of the execution.
     */
    public TriFunctionExecutionBuilder(TriFunction<A, B, C, RESULT> lambda, List<Object> params, ExecutionContext context) {
        super(lambda, params, context, BiFunctionExecutionBuilder::new);
    }
}
