package org.mule.commons.atlantic.lambda.consumer;

import org.mule.commons.atlantic.lambda.function.AtlanticFunction;

/**
 * Interface that identifies a Functional Interface as a consumer that receives one or more parameters.
 * Atlantic Consumers can be converted to an {@link AtlanticFunction} that always returns null and has a Void return type.
 *
 * @param <F> The Type of {@link AtlanticFunction} that this consumer can be converted to.
 */
public interface AtlanticConsumer<F extends AtlanticFunction> {

    /**
     * Converts this consumer into an {@link AtlanticFunction} that executes this consumer and then returns null.
     *
     * @return AtlanticFunction The converted function.
     */
    F toFunction();
}
