package org.mule.commons.atlantic.lambda.consumer;

import org.mule.commons.atlantic.lambda.function.HendecaFunction;

/**
 * Represents an operation that accepts eleven input arguments and returns no result.  This is the eleven-arity
 * specialization of {@link Consumer}.
 * Unlike most other functional interfaces, {@code HendecaConsumer} is expected to operate via side-effects.
 *
 * This is a functional interface whose functional method is {@link #accept(Object, Object, Object, Object, Object, Object, Object, Object, Object, Object, Object)}.
 *
 * @param <A> The type of the first argument to the operation.
 * @param <B> The type of the second argument to the operation.
 * @param <C> The type of the third argument to the operation.
 * @param <D> The type of the fourth argument to the operation.
 * @param <E> The type of the fifth argument to the operation.
 * @param <F> The type of the sixth argument to the operation.
 * @param <G> The type of the seventh argument to the operation.
 * @param <H> The type of the eighth argument to the operation.
 * @param <I> The type of the ninth argument to the operation.
 * @param <J> The type of the tenth argument to the operation.
 * @param <K> The type of the eleventh argument to the operation.
 */
@FunctionalInterface
public interface HendecaConsumer<A, B, C, D, E, F, G, H, I, J, K> extends AtlanticConsumer<HendecaFunction<A, B, C, D, E, F, G, H, I, J, K, Void>> {

    /**
     * Performs this operation on the given arguments.
     *
     * @param a The first input argument.
     * @param b The second input argument.
     * @param c The third input argument.
     * @param d The fourth input argument.
     * @param e The fifth input argument.
     * @param f The sixth input argument.
     * @param g The seventh input argument.
     * @param h The eighth input argument.
     * @param i The ninth input argument.
     * @param j The tenth input argument.
     * @param k The eleventh input argument.
     * @throws Throwable Any exception that the operation will throw.
     */
    void accept(A a, B b, C c, D d, E e, F f, G g, H h, I i, J j, K k) throws Throwable;

    @Override
    default HendecaFunction<A, B, C, D, E, F, G, H, I, J, K, Void> toFunction() {
        return (a, b, c, d, e, f, g, h, i, j, k) -> {
            accept(a, b, c, d, e, f, g, h, i, j, k);
            return null;
        };
    }
}
