package org.mule.commons.atlantic.lambda.function;

import java.util.Objects;

/**
 * Represents a function that accepts eleven arguments and produces a result.
 * This is the eleven-arity specialization of {@link Function}.
 *
 * This is a functional interface whose functional method is {@link #apply(Object, Object, Object, Object, Object, Object, Object, Object, Object, Object, Object)}.
 *
 * @param <A>      The type of the first argument to the function
 * @param <B>      The type of the second argument to the function
 * @param <C>      The type of the third argument to the function
 * @param <D>      The type of the fourth argument to the function
 * @param <E>      The type of the fifth argument to the function
 * @param <F>      The type of the sixth argument to the function
 * @param <G>      The type of the seventh argument to the function
 * @param <H>      The type of the eighth argument to the function
 * @param <I>      The type of the ninth argument to the function
 * @param <J>      The type of the tenth argument to the function
 * @param <K>      The type of the eleventh argument to the function
 * @param <RESULT> The type of the result of the function
 */
@FunctionalInterface
public interface HendecaFunction<A, B, C, D, E, F, G, H, I, J, K, RESULT> extends AtlanticFunction<A, DecaFunction<B, C, D, E, F, G, H, I, J, K, RESULT>> {

    /**
     * Applies this function to the given arguments.
     *
     * @param a The first function argument.
     * @param b The second function argument.
     * @param c The third function argument.
     * @param d The fourth function argument.
     * @param e The fifth function argument.
     * @param f The sixth function argument.
     * @param g The seventh function argument.
     * @param h The eighth function argument.
     * @param i The ninth function argument.
     * @param j The tenth function argument.
     * @param k The eleventh function argument.
     * @return Object The function result.
     * @throws Throwable Any exception that the operation will throw.
     */
    RESULT apply(A a, B b, C c, D d, E e, F f, G g, H h, I i, J j, K k) throws Throwable;

    @Override
    default DecaFunction<B, C, D, E, F, G, H, I, J, K, RESULT> downgrade(A a) {
        return (b, c, d, e, f, g, h, i, j, k) -> apply(a, b, c, d, e, f, g, h, i, j, k);
    }

    /**
     * Returns a composed hendecafunction that first applies this hendecafunction to its input, and then applies the {@code after}
     * function to the result.
     * If evaluation of either function throws an exception, it is relayed to the caller of the composed function.
     *
     * @param <AFTER_RESULT> The type of output of the {@code after} function, and of the composed function.
     * @param after          The function to apply after this function is applied.
     * @return HendecaFunction A composed hendecafunction that first applies this function and then applies the {@code after} function
     */
    default <AFTER_RESULT> HendecaFunction<A, B, C, D, E, F, G, H, I, J, K, AFTER_RESULT> andThen(Function<? super RESULT, ? extends AFTER_RESULT> after) {
        Objects.requireNonNull(after);
        return (A a, B b, C c, D d, E e, F f, G g, H h, I i, J j, K k) -> after.apply(apply(a, b, c, d, e, f, g, h, i, j, k));
    }
}
