package org.mule.commons.atlantic.execution.builder.lambda;

import org.mule.commons.atlantic.execution.ExecutionFactory;
import org.mule.commons.atlantic.lambda.AtlanticLambda;
import org.mule.commons.atlantic.lambda.supplier.Supplier;

public abstract class ExecutableLambdaBuilder<LAMBDA extends AtlanticLambda, PARAM, NEXT> extends LambdaBuilder<LAMBDA, PARAM, NEXT> {

    private final ExecutionFactory executionFactory;

    public ExecutableLambdaBuilder(LAMBDA lambda, ExecutionFactory executionFactory) {
        super(lambda);
        this.executionFactory = executionFactory;
    }

    public NEXT withParam(LAMBDA lambda, Supplier<PARAM> paramSupplier) {
        return withParam(lambda, paramSupplier, executionFactory);
    }

    protected abstract NEXT withParam(LAMBDA lambda, Supplier<PARAM> paramSupplier, ExecutionFactory executionFactory);
}
