package org.mule.commons.atlantic.execution.builder.lambda;

import org.mule.commons.atlantic.lambda.AtlanticLambda;
import org.mule.commons.atlantic.lambda.function.Function;
import org.mule.commons.atlantic.lambda.supplier.Supplier;

import static org.mule.commons.atlantic.lambda.supplier.Supplier.fixedSupplier;

public abstract class LambdaBuilder<LAMBDA extends AtlanticLambda, PARAM, NEXT> {

    private final LAMBDA lambda;

    public LambdaBuilder(LAMBDA lambda) {
        this.lambda = lambda;
    }

    public <INPUT> NEXT withParam(INPUT input, Function<INPUT, PARAM> parser) {
        return withParam(parser.downgrade(input));
    }

    public NEXT withParam(PARAM param) {
        return withParam(fixedSupplier(param));
    }

    public NEXT withParam(Supplier<PARAM> paramSupplier) {
        return withParam(lambda, paramSupplier);
    }

    protected abstract NEXT withParam(LAMBDA lambda, Supplier<PARAM> paramSupplier);
}
