package org.mule.commons.atlantic.execution.builder.lambda.runnable;

import org.mule.commons.atlantic.execution.builder.factory.ExecutionFactoryBuilder;
import org.mule.commons.atlantic.lambda.consumer.*;
import org.mule.commons.atlantic.lambda.supplier.Supplier;

public interface InstanceRunnableBuilderFactory<INSTANCE, SELF extends InstanceRunnableBuilderFactory> extends ExecutionFactoryBuilder<SELF> {

    default <B, C, D, E, F, G, H, I, J, K> Runnable10ParamsBuilder<B, C, D, E, F, G, H, I, J, K> execute(HendecaConsumer<INSTANCE, B, C, D, E, F, G, H, I, J, K> lambda) {
        return new Runnable11ParamsBuilder<>(lambda, buildExecutionFactory()).withParam(getInstanceSupplier());
    }

    default <B, C, D, E, F, G, H, I, J> Runnable9ParamsBuilder<B, C, D, E, F, G, H, I, J> execute(DecaConsumer<INSTANCE, B, C, D, E, F, G, H, I, J> lambda) {
        return new Runnable10ParamsBuilder<>(lambda, buildExecutionFactory()).withParam(getInstanceSupplier());
    }
    default <B, C, D, E, F, G, H, I> Runnable8ParamsBuilder<B, C, D, E, F, G, H, I> execute(NonaConsumer<INSTANCE, B, C, D, E, F, G, H, I> lambda) {
        return new Runnable9ParamsBuilder<>(lambda, buildExecutionFactory()).withParam(getInstanceSupplier());
    }
    default <B, C, D, E, F, G, H> Runnable7ParamsBuilder<B, C, D, E, F, G, H> execute(OctaConsumer<INSTANCE, B, C, D, E, F, G, H> lambda) {
        return new Runnable8ParamsBuilder<>(lambda, buildExecutionFactory()).withParam(getInstanceSupplier());
    }
    default <B, C, D, E, F, G> Runnable6ParamsBuilder<B, C, D, E, F, G> execute(HeptaConsumer<INSTANCE, B, C, D, E, F, G> lambda) {
        return new Runnable7ParamsBuilder<>(lambda, buildExecutionFactory()).withParam(getInstanceSupplier());
    }
    default <B, C, D, E, F> Runnable5ParamsBuilder<B, C, D, E, F> execute(HexaConsumer<INSTANCE, B, C, D, E, F> lambda) {
        return new Runnable6ParamsBuilder<>(lambda, buildExecutionFactory()).withParam(getInstanceSupplier());
    }
    default <B, C, D, E> Runnable4ParamsBuilder<B, C, D, E> execute(PentaConsumer<INSTANCE, B, C, D, E> lambda) {
        return new Runnable5ParamsBuilder<>(lambda, buildExecutionFactory()).withParam(getInstanceSupplier());
    }
    default <B, C, D> Runnable3ParamsBuilder<B, C, D> execute(TetraConsumer<INSTANCE, B, C, D> lambda) {
        return new Runnable4ParamsBuilder<>(lambda, buildExecutionFactory()).withParam(getInstanceSupplier());
    }
    default <B, C> Runnable2ParamsBuilder<B, C> execute(TriConsumer<INSTANCE, B, C> lambda) {
        return new Runnable3ParamsBuilder<>(lambda, buildExecutionFactory()).withParam(getInstanceSupplier());
    }
    default <B> Runnable1ParamBuilder<B> execute(BiConsumer<INSTANCE, B> lambda) {
        return new Runnable2ParamsBuilder<>(lambda, buildExecutionFactory()).withParam(getInstanceSupplier());
    }
    default void execute(Consumer<INSTANCE> lambda) {
        new Runnable1ParamBuilder<>(lambda, buildExecutionFactory()).withParam(getInstanceSupplier());
    }

    Supplier<INSTANCE> getInstanceSupplier();
}
