package org.mule.commons.atlantic.execution.builder.lambda.runnable;

import org.mule.commons.atlantic.execution.ExecutionFactory;
import org.mule.commons.atlantic.lambda.consumer.Consumer;
import org.mule.commons.atlantic.lambda.function.Function;
import org.mule.commons.atlantic.lambda.supplier.Supplier;

import static org.mule.commons.atlantic.lambda.supplier.Supplier.fixedSupplier;

public class Runnable1ParamBuilder<PARAM> {

    private final Consumer<PARAM> lambda;
    private final ExecutionFactory executionFactory;

    public Runnable1ParamBuilder(Consumer<PARAM> lambda, ExecutionFactory executionFactory) {
        this.lambda = lambda;
        this.executionFactory = executionFactory;
    }

    public <INPUT> void withParam(INPUT input, Function<INPUT, PARAM> parser) {
        withParam(parser.downgrade(input));
    }

    public void withParam(PARAM param) {
        withParam(fixedSupplier(param));
    }

    public void withParam(Supplier<PARAM> paramSupplier) {
        executionFactory.create(lambda.downgrade(paramSupplier)).execute();
    }
}
