package org.mule.commons.atlantic.execution.builder.lambda.runnable;

import org.mule.commons.atlantic.execution.builder.factory.ExecutionFactoryBuilder;
import org.mule.commons.atlantic.lambda.consumer.*;
import org.mule.commons.atlantic.lambda.runnable.Runnable;

public interface RunnableBuilderFactory<SELF extends RunnableBuilderFactory> extends ExecutionFactoryBuilder<SELF> {

    default <PARAM, B, C, D, E, F, G, H, I, J, K> Runnable11ParamsBuilder<PARAM, B, C, D, E, F, G, H, I, J, K> execute(HendecaConsumer<PARAM, B, C, D, E, F, G, H, I, J, K> lambda) {
        return new Runnable11ParamsBuilder<>(lambda, buildExecutionFactory());
    }
    default <PARAM, B, C, D, E, F, G, H, I, J> Runnable10ParamsBuilder<PARAM, B, C, D, E, F, G, H, I, J> execute(DecaConsumer<PARAM, B, C, D, E, F, G, H, I, J> lambda) {
        return new Runnable10ParamsBuilder<>(lambda, buildExecutionFactory());
    }
    default <PARAM, B, C, D, E, F, G, H, I> Runnable9ParamsBuilder<PARAM, B, C, D, E, F, G, H, I> execute(NonaConsumer<PARAM, B, C, D, E, F, G, H, I> lambda) {
        return new Runnable9ParamsBuilder<>(lambda, buildExecutionFactory());
    }
    default <PARAM, B, C, D, E, F, G, H> Runnable8ParamsBuilder<PARAM, B, C, D, E, F, G, H> execute(OctaConsumer<PARAM, B, C, D, E, F, G, H> lambda) {
        return new Runnable8ParamsBuilder<>(lambda, buildExecutionFactory());
    }
    default <PARAM, B, C, D, E, F, G> Runnable7ParamsBuilder<PARAM, B, C, D, E, F, G> execute(HeptaConsumer<PARAM, B, C, D, E, F, G> lambda) {
        return new Runnable7ParamsBuilder<>(lambda, buildExecutionFactory());
    }
    default <PARAM, B, C, D, E, F> Runnable6ParamsBuilder<PARAM, B, C, D, E, F> execute(HexaConsumer<PARAM, B, C, D, E, F> lambda) {
        return new Runnable6ParamsBuilder<>(lambda, buildExecutionFactory());
    }
    default <PARAM, B, C, D, E> Runnable5ParamsBuilder<PARAM, B, C, D, E> execute(PentaConsumer<PARAM, B, C, D, E> lambda) {
        return new Runnable5ParamsBuilder<>(lambda, buildExecutionFactory());
    }
    default <PARAM, B, C, D> Runnable4ParamsBuilder<PARAM, B, C, D> execute(TetraConsumer<PARAM, B, C, D> lambda) {
        return new Runnable4ParamsBuilder<>(lambda, buildExecutionFactory());
    }
    default <PARAM, B, C> Runnable3ParamsBuilder<PARAM, B, C> execute(TriConsumer<PARAM, B, C> lambda) {
        return new Runnable3ParamsBuilder<>(lambda, buildExecutionFactory());
    }
    default <PARAM, B> Runnable2ParamsBuilder<PARAM, B> execute(BiConsumer<PARAM, B> lambda) {
        return new Runnable2ParamsBuilder<>(lambda, buildExecutionFactory());
    }
    default <PARAM> Runnable1ParamBuilder<PARAM> execute(Consumer<PARAM> lambda) {
        return new Runnable1ParamBuilder<>(lambda, buildExecutionFactory());
    }
    default void execute(Runnable lambda) {
        buildExecutionFactory().create(lambda).execute();
    }
}
