package org.mule.commons.atlantic.execution.builder.lambda.supplier;

import org.mule.commons.atlantic.execution.builder.factory.ExecutionFactoryBuilder;
import org.mule.commons.atlantic.lambda.function.*;
import org.mule.commons.atlantic.lambda.supplier.Supplier;

public interface InstanceSupplierBuilderFactory<INSTANCE, SELF extends InstanceSupplierBuilderFactory> extends ExecutionFactoryBuilder<SELF> {

    default <B, C, D, E, F, G, H, I, J, K, RESULT> Supplier10ParamsBuilder<B, C, D, E, F, G, H, I, J, K, RESULT> execute(HendecaFunction<INSTANCE, B, C, D, E, F, G, H, I, J, K, RESULT> lambda) {
        return new Supplier11ParamsBuilder<>(lambda, buildExecutionFactory()).withParam(getInstanceSupplier());
    }
    default <B, C, D, E, F, G, H, I, J, RESULT> Supplier9ParamsBuilder<B, C, D, E, F, G, H, I, J, RESULT> execute(DecaFunction<INSTANCE, B, C, D, E, F, G, H, I, J, RESULT> lambda) {
        return new Supplier10ParamsBuilder<>(lambda, buildExecutionFactory()).withParam(getInstanceSupplier());
    }
    default <B, C, D, E, F, G, H, I, RESULT> Supplier8ParamsBuilder<B, C, D, E, F, G, H, I, RESULT> execute(NonaFunction<INSTANCE, B, C, D, E, F, G, H, I, RESULT> lambda) {
        return new Supplier9ParamsBuilder<>(lambda, buildExecutionFactory()).withParam(getInstanceSupplier());
    }
    default <B, C, D, E, F, G, H, RESULT> Supplier7ParamsBuilder<B, C, D, E, F, G, H, RESULT> execute(OctaFunction<INSTANCE, B, C, D, E, F, G, H, RESULT> lambda) {
        return new Supplier8ParamsBuilder<>(lambda, buildExecutionFactory()).withParam(getInstanceSupplier());
    }
    default <B, C, D, E, F, G, RESULT> Supplier6ParamsBuilder<B, C, D, E, F, G, RESULT> execute(HeptaFunction<INSTANCE, B, C, D, E, F, G, RESULT> lambda) {
        return new Supplier7ParamsBuilder<>(lambda, buildExecutionFactory()).withParam(getInstanceSupplier());
    }
    default <B, C, D, E, F, RESULT> Supplier5ParamsBuilder<B, C, D, E, F, RESULT> execute(HexaFunction<INSTANCE, B, C, D, E, F, RESULT> lambda) {
        return new Supplier6ParamsBuilder<>(lambda, buildExecutionFactory()).withParam(getInstanceSupplier());
    }
    default <B, C, D, E, RESULT> Supplier4ParamsBuilder<B, C, D, E, RESULT> execute(PentaFunction<INSTANCE, B, C, D, E, RESULT> lambda) {
        return new Supplier5ParamsBuilder<>(lambda, buildExecutionFactory()).withParam(getInstanceSupplier());
    }
    default <B, C, D, RESULT> Supplier3ParamsBuilder<B, C, D, RESULT> execute(TetraFunction<INSTANCE, B, C, D, RESULT> lambda) {
        return new Supplier4ParamsBuilder<>(lambda, buildExecutionFactory()).withParam(getInstanceSupplier());
    }
    default <B, C, RESULT> Supplier2ParamsBuilder<B, C, RESULT> execute(TriFunction<INSTANCE, B, C, RESULT> lambda) {
        return new Supplier3ParamsBuilder<>(lambda, buildExecutionFactory()).withParam(getInstanceSupplier());
    }
    default <B, RESULT> Supplier1ParamBuilder<B, RESULT> execute(BiFunction<INSTANCE, B, RESULT> lambda) {
        return new Supplier2ParamsBuilder<>(lambda, buildExecutionFactory()).withParam(getInstanceSupplier());
    }
    default <RESULT> RESULT execute(Function<INSTANCE, RESULT> lambda) {
        return new Supplier1ParamBuilder<>(lambda, buildExecutionFactory()).withParam(getInstanceSupplier());
    }

    Supplier<INSTANCE> getInstanceSupplier();
}
