package org.mule.commons.atlantic.execution.builder.lambda.supplier.chain;

import org.mule.commons.atlantic.execution.ExecutionFactory;
import org.mule.commons.atlantic.execution.builder.lambda.runnable.*;
import org.mule.commons.atlantic.execution.builder.lambda.supplier.*;
import org.mule.commons.atlantic.lambda.consumer.*;
import org.mule.commons.atlantic.lambda.function.*;
import org.mule.commons.atlantic.lambda.supplier.Supplier;

public class ChainedSupplier<RESULT> implements Supplier<RESULT> {

    private final Supplier<RESULT> delegate;
    private final ExecutionFactory executionFactory;

    public ChainedSupplier(Supplier<RESULT> delegate, ExecutionFactory executionFactory) {
        this.delegate = delegate;
        this.executionFactory = executionFactory;
    }

    @Override
    public RESULT get() throws Throwable {
        return delegate.get();
    }

    public <PARAM, B, C, D, E, F, G, H, I, J, NEXT_RESULT> ChainedSupplier10ParamsBuilder<PARAM, B, C, D, E, F, G, H, I, J, NEXT_RESULT> andThenExecute(HendecaFunction<RESULT, PARAM, B, C, D, E, F, G, H, I, J, NEXT_RESULT> lambda) {
        return new ChainedSupplier11ParamsBuilder<>(lambda, executionFactory).withParam(this);
    }
    public <PARAM, B, C, D, E, F, G, H, I, NEXT_RESULT> ChainedSupplier9ParamsBuilder<PARAM, B, C, D, E, F, G, H, I, NEXT_RESULT> andThenExecute(DecaFunction<RESULT, PARAM, B, C, D, E, F, G, H, I, NEXT_RESULT> lambda) {
        return new ChainedSupplier10ParamsBuilder<>(lambda, executionFactory).withParam(this);
    }
    public <PARAM, B, C, D, E, F, G, H, NEXT_RESULT> ChainedSupplier8ParamsBuilder<PARAM, B, C, D, E, F, G, H, NEXT_RESULT> andThenExecute(NonaFunction<RESULT, PARAM, B, C, D, E, F, G, H, NEXT_RESULT> lambda) {
        return new ChainedSupplier9ParamsBuilder<>(lambda, executionFactory).withParam(this);
    }
    public <PARAM, B, C, D, E, F, G, NEXT_RESULT> ChainedSupplier7ParamsBuilder<PARAM, B, C, D, E, F, G, NEXT_RESULT> andThenExecute(OctaFunction<RESULT, PARAM, B, C, D, E, F, G, NEXT_RESULT> lambda) {
        return new ChainedSupplier8ParamsBuilder<>(lambda, executionFactory).withParam(this);
    }
    public <PARAM, B, C, D, E, F, NEXT_RESULT> ChainedSupplier6ParamsBuilder<PARAM, B, C, D, E, F, NEXT_RESULT> andThenExecute(HeptaFunction<RESULT, PARAM, B, C, D, E, F, NEXT_RESULT> lambda) {
        return new ChainedSupplier7ParamsBuilder<>(lambda, executionFactory).withParam(this);
    }
    public <PARAM, B, C, D, E, NEXT_RESULT> ChainedSupplier5ParamsBuilder<PARAM, B, C, D, E, NEXT_RESULT> andThenExecute(HexaFunction<RESULT, PARAM, B, C, D, E, NEXT_RESULT> lambda) {
        return new ChainedSupplier6ParamsBuilder<>(lambda, executionFactory).withParam(this);
    }
    public <PARAM, B, C, D, NEXT_RESULT> ChainedSupplier4ParamsBuilder<PARAM, B, C, D, NEXT_RESULT> andThenExecute(PentaFunction<RESULT, PARAM, B, C, D, NEXT_RESULT> lambda) {
        return new ChainedSupplier5ParamsBuilder<>(lambda, executionFactory).withParam(this);
    }
    public <PARAM, B, C, NEXT_RESULT> ChainedSupplier3ParamsBuilder<PARAM, B, C, NEXT_RESULT> andThenExecute(TetraFunction<RESULT, PARAM, B, C, NEXT_RESULT> lambda) {
        return new ChainedSupplier4ParamsBuilder<>(lambda, executionFactory).withParam(this);
    }
    public <PARAM, B, NEXT_RESULT> ChainedSupplier2ParamsBuilder<PARAM, B, NEXT_RESULT> andThenExecute(TriFunction<RESULT, PARAM, B, NEXT_RESULT> lambda) {
        return new ChainedSupplier3ParamsBuilder<>(lambda, executionFactory).withParam(this);
    }
    public <PARAM, NEXT_RESULT> ChainedSupplier1ParamBuilder<PARAM, NEXT_RESULT> andThenExecute(BiFunction<RESULT, PARAM, NEXT_RESULT> lambda) {
        return new ChainedSupplier2ParamsBuilder<>(lambda, executionFactory).withParam(this);
    }
    public <NEXT_RESULT> ChainedSupplier<NEXT_RESULT> andThenExecute(Function<RESULT, NEXT_RESULT> lambda) {
        return new ChainedSupplier1ParamBuilder<>(lambda, executionFactory).withParam(this);
    }

    public <PARAM, B, C, D, E, F, G, H, I, J, NEXT_RESULT> Supplier10ParamsBuilder<PARAM, B, C, D, E, F, G, H, I, J, NEXT_RESULT> andFinallyExecute(HendecaFunction<RESULT, PARAM, B, C, D, E, F, G, H, I, J, NEXT_RESULT> lambda) {
        return new Supplier11ParamsBuilder<>(lambda, executionFactory).withParam(this);
    }
    public <PARAM, B, C, D, E, F, G, H, I, NEXT_RESULT> Supplier9ParamsBuilder<PARAM, B, C, D, E, F, G, H, I, NEXT_RESULT> andFinallyExecute(DecaFunction<RESULT, PARAM, B, C, D, E, F, G, H, I, NEXT_RESULT> lambda) {
        return new Supplier10ParamsBuilder<>(lambda, executionFactory).withParam(this);
    }
    public <PARAM, B, C, D, E, F, G, H, NEXT_RESULT> Supplier8ParamsBuilder<PARAM, B, C, D, E, F, G, H, NEXT_RESULT> andFinallyExecute(NonaFunction<RESULT, PARAM, B, C, D, E, F, G, H, NEXT_RESULT> lambda) {
        return new Supplier9ParamsBuilder<>(lambda, executionFactory).withParam(this);
    }
    public <PARAM, B, C, D, E, F, G, NEXT_RESULT> Supplier7ParamsBuilder<PARAM, B, C, D, E, F, G, NEXT_RESULT> andFinallyExecute(OctaFunction<RESULT, PARAM, B, C, D, E, F, G, NEXT_RESULT> lambda) {
        return new Supplier8ParamsBuilder<>(lambda, executionFactory).withParam(this);
    }
    public <PARAM, B, C, D, E, F, NEXT_RESULT> Supplier6ParamsBuilder<PARAM, B, C, D, E, F, NEXT_RESULT> andFinallyExecute(HeptaFunction<RESULT, PARAM, B, C, D, E, F, NEXT_RESULT> lambda) {
        return new Supplier7ParamsBuilder<>(lambda, executionFactory).withParam(this);
    }
    public <PARAM, B, C, D, E, NEXT_RESULT> Supplier5ParamsBuilder<PARAM, B, C, D, E, NEXT_RESULT> andFinallyExecute(HexaFunction<RESULT, PARAM, B, C, D, E, NEXT_RESULT> lambda) {
        return new Supplier6ParamsBuilder<>(lambda, executionFactory).withParam(this);
    }
    public <PARAM, B, C, D, NEXT_RESULT> Supplier4ParamsBuilder<PARAM, B, C, D, NEXT_RESULT> andFinallyExecute(PentaFunction<RESULT, PARAM, B, C, D, NEXT_RESULT> lambda) {
        return new Supplier5ParamsBuilder<>(lambda, executionFactory).withParam(this);
    }
    public <PARAM, B, C, NEXT_RESULT> Supplier3ParamsBuilder<PARAM, B, C, NEXT_RESULT> andFinallyExecute(TetraFunction<RESULT, PARAM, B, C, NEXT_RESULT> lambda) {
        return new Supplier4ParamsBuilder<>(lambda, executionFactory).withParam(this);
    }
    public <PARAM, B, NEXT_RESULT> Supplier2ParamsBuilder<PARAM, B, NEXT_RESULT> andFinallyExecute(TriFunction<RESULT, PARAM, B, NEXT_RESULT> lambda) {
        return new Supplier3ParamsBuilder<>(lambda, executionFactory).withParam(this);
    }
    public <PARAM, NEXT_RESULT> Supplier1ParamBuilder<PARAM, NEXT_RESULT> andFinallyExecute(BiFunction<RESULT, PARAM, NEXT_RESULT> lambda) {
        return new Supplier2ParamsBuilder<>(lambda, executionFactory).withParam(this);
    }
    public <NEXT_RESULT> NEXT_RESULT andFinallyExecute(Function<RESULT, NEXT_RESULT> lambda) {
        return new Supplier1ParamBuilder<>(lambda, executionFactory).withParam(this);
    }

    public <B, C, D, E, F, G, H, I, J, K> Runnable10ParamsBuilder<B, C, D, E, F, G, H, I, J, K> andFinallyExecute(HendecaConsumer<RESULT, B, C, D, E, F, G, H, I, J, K> lambda) {
        return new Runnable11ParamsBuilder<>(lambda, executionFactory).withParam(this);
    }
    public <B, C, D, E, F, G, H, I, J> Runnable9ParamsBuilder<B, C, D, E, F, G, H, I, J> andFinallyExecute(DecaConsumer<RESULT, B, C, D, E, F, G, H, I, J> lambda) {
        return new Runnable10ParamsBuilder<>(lambda, executionFactory).withParam(this);
    }
    public <B, C, D, E, F, G, H, I> Runnable8ParamsBuilder<B, C, D, E, F, G, H, I> andFinallyExecute(NonaConsumer<RESULT, B, C, D, E, F, G, H, I> lambda) {
        return new Runnable9ParamsBuilder<>(lambda, executionFactory).withParam(this);
    }
    public <B, C, D, E, F, G, H> Runnable7ParamsBuilder<B, C, D, E, F, G, H> andFinallyExecute(OctaConsumer<RESULT, B, C, D, E, F, G, H> lambda) {
        return new Runnable8ParamsBuilder<>(lambda, executionFactory).withParam(this);
    }
    public <B, C, D, E, F, G> Runnable6ParamsBuilder<B, C, D, E, F, G> andFinallyExecute(HeptaConsumer<RESULT, B, C, D, E, F, G> lambda) {
        return new Runnable7ParamsBuilder<>(lambda, executionFactory).withParam(this);
    }
    public <B, C, D, E, F> Runnable5ParamsBuilder<B, C, D, E, F> andFinallyExecute(HexaConsumer<RESULT, B, C, D, E, F> lambda) {
        return new Runnable6ParamsBuilder<>(lambda, executionFactory).withParam(this);
    }
    public <B, C, D, E> Runnable4ParamsBuilder<B, C, D, E> andFinallyExecute(PentaConsumer<RESULT, B, C, D, E> lambda) {
        return new Runnable5ParamsBuilder<>(lambda, executionFactory).withParam(this);
    }
    public <B, C, D> Runnable3ParamsBuilder<B, C, D> andFinallyExecute(TetraConsumer<RESULT, B, C, D> lambda) {
        return new Runnable4ParamsBuilder<>(lambda, executionFactory).withParam(this);
    }
    public <B, C> Runnable2ParamsBuilder<B, C> andFinallyExecute(TriConsumer<RESULT, B, C> lambda) {
        return new Runnable3ParamsBuilder<>(lambda, executionFactory).withParam(this);
    }
    public <B> Runnable1ParamBuilder<B> andFinallyExecute(BiConsumer<RESULT, B> lambda) {
        return new Runnable2ParamsBuilder<>(lambda, executionFactory).withParam(this);
    }
    public void andFinallyExecute(Consumer<RESULT> lambda) {
        new Runnable1ParamBuilder<>(lambda, executionFactory).withParam(this);
    }
}
