package org.mule.commons.atlantic.execution.builder.lambda.supplier.chain;

import org.mule.commons.atlantic.execution.ExecutionFactory;
import org.mule.commons.atlantic.execution.builder.lambda.ExecutableLambdaBuilder;
import org.mule.commons.atlantic.lambda.function.TriFunction;
import org.mule.commons.atlantic.lambda.supplier.Supplier;

public class ChainedSupplier3ParamsBuilder<PARAM, B, C, RESULT> extends ExecutableLambdaBuilder<TriFunction<PARAM, B, C, RESULT>, PARAM, ChainedSupplier2ParamsBuilder<B, C, RESULT>> {

    public ChainedSupplier3ParamsBuilder(TriFunction<PARAM, B, C, RESULT> lambda, ExecutionFactory executionFactory) {
        super(lambda, executionFactory);
    }

    @Override
    protected ChainedSupplier2ParamsBuilder<B, C, RESULT> withParam(TriFunction<PARAM, B, C, RESULT> lambda, Supplier<PARAM> paramSupplier, ExecutionFactory executionFactory) {
        return new ChainedSupplier2ParamsBuilder<>(lambda.downgrade(paramSupplier), executionFactory);
    }
}
