package org.mule.commons.atlantic.lambda.consumer;

import org.mule.commons.atlantic.lambda.AtlanticLambda;
import org.mule.commons.atlantic.lambda.function.AtlanticFunction;
import org.mule.commons.atlantic.lambda.supplier.Supplier;

import static org.mule.commons.atlantic.lambda.supplier.Supplier.fixedSupplier;

/**
 * Interface that identifies a Functional Interface as a consumer that receives one or more parameters.
 * Atlantic Consumers can be converted to an {@link AtlanticFunction} that always returns null and has a Void return type.
 *
 * @param <F> The Type of {@link AtlanticFunction} that this consumer can be converted to.
 */
public interface AtlanticConsumer<PARAM, NEXT extends AtlanticLambda, F extends AtlanticFunction> extends AtlanticLambda {

    /**
     * Converts this {@link AtlanticFunction} into another that has the same parameters save for the first one. Invocation
     * of the returned {@link AtlanticLambda} will call this one with the provided parameter.
     *
     * @param param The parameter that will be passed to this {@link AtlanticFunction}.
     * @return AtlanticLambda This lambda without the first parameter.
     */
    default NEXT downgrade(PARAM param) {
        return downgrade(fixedSupplier(param));
    }

    NEXT downgrade(Supplier<PARAM> paramSupplier);

    /**
     * Converts this consumer into an {@link AtlanticFunction} that executes this consumer and then returns null.
     *
     * @return AtlanticFunction The converted function.
     */
    F toFunction();
}
