package org.mule.commons.atlantic;

import org.mule.commons.atlantic.execution.builder.factory.instance.InstanceExecutionFactoryBuilder;
import org.mule.commons.atlantic.execution.builder.factory.statically.StaticExecutionFactoryBuilder;
import org.mule.commons.atlantic.lambda.supplier.Supplier;

import static org.mule.commons.atlantic.lambda.supplier.Supplier.fixedSupplier;

/**
 * Main class.
 * This class contains the starter methods to execute both instance methods and static methods/constructors.
 * The first type will require a created object to work, while the second one will not.
 * Normally, regular instance method calls will use the {@link Atlantic#forInstance(Object)} method and
 * both static method calls and  constructor calls will use the {@link Atlantic#statically()} one.
 * It is possible to use instance methods on using the static executor by setting the instance to be executed as the
 * first parameter but it's not recommended.
 * This class cannot and should not be extended and only provides the 2 static methods for building executions.
 */
public final class Atlantic {

    /**
     * Private constructor. Ensures that the class cannot be instantiated.
     */
    private Atlantic() {
        // Do nothing.
    }

    public static <INSTANCE> InstanceExecutionFactoryBuilder<INSTANCE> forInstance(INSTANCE instance) {
        return new InstanceExecutionFactoryBuilder<>(fixedSupplier(instance));
    }

    public static <INSTANCE> InstanceExecutionFactoryBuilder<INSTANCE> forSuppliedInstance(Supplier<INSTANCE> instance) {
        return new InstanceExecutionFactoryBuilder<>(instance);
    }

    public static StaticExecutionFactoryBuilder statically() {
        return new StaticExecutionFactoryBuilder();
    }
}
