package org.mule.commons.atlantic.execution;

import org.mule.commons.atlantic.execution.listener.OnFailureListener;
import org.mule.commons.atlantic.execution.listener.OnPreExecutionListener;
import org.mule.commons.atlantic.execution.listener.OnSuccessListener;
import org.mule.commons.atlantic.lambda.supplier.Supplier;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class Execution<RESULT> {
    private final static Logger logger = LoggerFactory.getLogger(Execution.class);
    private final Supplier<RESULT> supplier;
    private final OnPreExecutionListener onPreExecutionListener;
    private final OnSuccessListener onSuccessListener;
    private final OnFailureListener onFailureListener;

    public Execution(Supplier<RESULT> supplier, OnPreExecutionListener onPreExecutionListener, OnSuccessListener onSuccessListener, OnFailureListener onFailureListener) {
        this.supplier = supplier;
        this.onPreExecutionListener = onPreExecutionListener;
        this.onSuccessListener = onSuccessListener;
        this.onFailureListener = onFailureListener;
    }

    public RESULT execute() {
        try {
            logger.debug("Running pre-execution listener.");
            onPreExecutionListener.onPreExecution();
            logger.debug("Pre-execution listener run successfully.");
            logger.debug("Executing supplier.");
            RESULT result = supplier.get();
            logger.debug("Supplier executed successfully.");
            logger.debug("Running post-execution success listener.");
            onSuccessListener.onSuccess(result);
            logger.debug("Post-execution success listener run successfully.");
            return result;
        } catch (Throwable throwable) {
            logger.debug("An exception was raised executing the supplier.");
            logger.debug("Running post-execution failure listener.");
            onFailureListener.onFailure(throwable);
            logger.debug("Post-execution failure listener run successfully.");
            return null;
        }
    }
}
