package org.mule.commons.atlantic.execution;

import org.mule.commons.atlantic.execution.listener.OnFailureListener;
import org.mule.commons.atlantic.execution.listener.OnPreExecutionListener;
import org.mule.commons.atlantic.execution.listener.OnSuccessListener;
import org.mule.commons.atlantic.lambda.runnable.Runnable;
import org.mule.commons.atlantic.lambda.supplier.Supplier;

public class ExecutionFactory {

    private final OnPreExecutionListener onPreExecutionListener;
    private final OnSuccessListener onSuccessListener;
    private final OnFailureListener onFailureListener;

    public ExecutionFactory(OnPreExecutionListener onPreExecutionListener,
                            OnSuccessListener onSuccessListener,
                            OnFailureListener onFailureListener) {
        this.onPreExecutionListener = onPreExecutionListener;
        this.onSuccessListener = onSuccessListener;
        this.onFailureListener = onFailureListener;
    }

    public <RESULT> Execution<RESULT> create(Supplier<RESULT> supplier) {
        return new Execution<>(supplier, onPreExecutionListener, onSuccessListener, onFailureListener);
    }

    public Execution<Void> create(Runnable runnable) {
        return new Execution<>(runnable.toSupplier(), onPreExecutionListener, onSuccessListener, onFailureListener);
    }
}
