package org.mule.commons.atlantic.execution.builder.factory;

import org.mule.commons.atlantic.execution.ExecutionFactory;
import org.mule.commons.atlantic.execution.exception.handler.DefinedExceptionHandler;
import org.mule.commons.atlantic.execution.exception.handler.ExceptionHandler;
import org.mule.commons.atlantic.execution.listener.OnPreExecutionListener;
import org.mule.commons.atlantic.execution.listener.OnSuccessListener;

import java.util.List;

public class ExecutionFactoryBuilderDelegate<SELF extends ExecutionFactoryBuilderDelegate, DELEGATE extends ExecutionFactoryBuilder> implements ExecutionFactoryBuilder<SELF> {
    private final DELEGATE delegate;

    public ExecutionFactoryBuilderDelegate(DELEGATE delegate) {
        this.delegate = delegate;
    }

    @Override
    public SELF withPreExecutionListener(OnPreExecutionListener... onPreExecutionListeners) {
        delegate.withPreExecutionListener(onPreExecutionListeners);
        return (SELF)this;
    }

    @Override
    public SELF withPreExecutionListener(List<OnPreExecutionListener> onPreExecutionListeners) {
        delegate.withPreExecutionListener(onPreExecutionListeners);
        return (SELF)this;
    }

    @Override
    public SELF withPostExecutionListener(OnSuccessListener... onSuccessListeners) {
        delegate.withPostExecutionListener(onSuccessListeners);
        return (SELF)this;
    }

    @Override
    public SELF withPostExecutionListener(List<OnSuccessListener> onSuccessListeners) {
        delegate.withPostExecutionListener(onSuccessListeners);
        return (SELF)this;
    }

    @Override
    public <T extends Throwable> SELF withExceptionHandler(Class<T> exceptionClass, ExceptionHandler<T> exceptionHandler) {
        delegate.withExceptionHandler(exceptionClass, exceptionHandler);
        return (SELF)this;
    }

    @Override
    public <T extends Throwable> SELF withExceptionHandler(DefinedExceptionHandler<T> exceptionHandler) {
        delegate.withExceptionHandler(exceptionHandler);
        return (SELF)this;
    }

    @Override
    public <T extends RuntimeException> SELF withIgnoredExceptionType(Class<T> exceptionClass) {
        delegate.withIgnoredExceptionType(exceptionClass);
        return (SELF)this;
    }

    @Override
    public ExecutionFactory buildExecutionFactory() {
        return delegate.buildExecutionFactory();
    }

    protected DELEGATE getDelegate() {
        return delegate;
    }
}
