package org.mule.commons.atlantic.execution.builder.factory.statically;

import org.mule.commons.atlantic.execution.builder.factory.DefaultExecutionFactoryBuilder;
import org.mule.commons.atlantic.execution.builder.lambda.runnable.RunnableBuilderFactory;
import org.mule.commons.atlantic.execution.builder.lambda.supplier.SupplierBuilderFactory;

/**
 * DefaultExecutionFactoryBuilder in charge of executing static methods and constructors.
 *
 * This class contains a set of configuration methods an a series overloaded methods called execute.
 * Each of these execute methods allow for the execution of a different type of static method or constructor, starting
 * from no parameters to up to 10 parameters on it.
 * The configuration methods allow to set a list of pre execution listeners, another list of post execution listeners,
 * a list of exception handlers and the handler for the thread execution.
 *
 * The execution for such methods will follow the following code:
 *
 * <code>
 *     MyResult result = new StaticExecutionFactoryBuilder().execute(MyClass::myStaticMethod)
 *         .withParam(param1)
 *         .withParam(param2);
 * </code>
 *
 * Where myStaticMethod is a static method on the MyClass class, param1 is the first parameter on myStaticMethod,
 * param2 is the second (and last) parameter on myStaticMethod and MyResult is the returning object of
 * myStaticMethod. This means that that execution is the equivalent of doing:
 *
 * <code>
 *     MyResult result = MyClass.myStaticMethod.myMethod(param1, param2);
 * </code>
 *
 * Optionally, an additional execution for this executor can follow the following code:
 *
 * <code>
 *     MyClass newMyClassInstance = new StaticExecutionFactoryBuilder().execute(MyClass::new)
 *         .withParam(param1)
 *         .withParam(param2);
 * </code>
 *
 * Where newMyClassInstance is an instance of the MyClass class, param1 is the first parameter on the constructor,
 * param2 is the second (and last) parameter on the constructor.
 *
 * The advantage of doing this in this way is all the wrappers and listeners that we can add to the execution.
 */
public class StaticExecutionFactoryBuilder extends DefaultExecutionFactoryBuilder<StaticExecutionFactoryBuilder> implements SupplierBuilderFactory<StaticExecutionFactoryBuilder>, RunnableBuilderFactory<StaticExecutionFactoryBuilder> {

    public ChainedExecutionFactoryBuilder chain() {
        return new ChainedExecutionFactoryBuilder(this);
    }
}
