package org.mule.commons.atlantic.execution.builder.lambda.runnable;

import org.mule.commons.atlantic.execution.ExecutionFactory;
import org.mule.commons.atlantic.execution.builder.lambda.ExecutableLambdaBuilder;
import org.mule.commons.atlantic.lambda.consumer.TetraConsumer;
import org.mule.commons.atlantic.lambda.supplier.Supplier;

public class Runnable4ParamsBuilder<PARAM, B, C, D> extends ExecutableLambdaBuilder<TetraConsumer<PARAM, B, C, D>, PARAM, Runnable3ParamsBuilder<B, C, D>> {

    public Runnable4ParamsBuilder(TetraConsumer<PARAM, B, C, D> lambda, ExecutionFactory executionFactory) {
        super(lambda, executionFactory);
    }

    @Override
    protected Runnable3ParamsBuilder<B, C, D> withParam(TetraConsumer<PARAM, B, C, D> lambda, Supplier<PARAM> paramSupplier, ExecutionFactory executionFactory) {
        return new Runnable3ParamsBuilder<>(lambda.downgrade(paramSupplier), executionFactory);
    }
}
