package org.mule.commons.atlantic.execution.builder.lambda.supplier;

import org.mule.commons.atlantic.execution.builder.factory.ExecutionFactoryBuilder;
import org.mule.commons.atlantic.lambda.function.*;
import org.mule.commons.atlantic.lambda.supplier.Supplier;

public interface SupplierBuilderFactory<SELF extends SupplierBuilderFactory> extends ExecutionFactoryBuilder<SELF> {

    default <PARAM, B, C, D, E, F, G, H, I, J, K, RESULT> Supplier11ParamsBuilder<PARAM, B, C, D, E, F, G, H, I, J, K, RESULT> execute(HendecaFunction<PARAM, B, C, D, E, F, G, H, I, J, K, RESULT> lambda) {
        return new Supplier11ParamsBuilder<>(lambda, buildExecutionFactory());
    }
    default <PARAM, B, C, D, E, F, G, H, I, J, RESULT> Supplier10ParamsBuilder<PARAM, B, C, D, E, F, G, H, I, J, RESULT> execute(DecaFunction<PARAM, B, C, D, E, F, G, H, I, J, RESULT> lambda) {
        return new Supplier10ParamsBuilder<>(lambda, buildExecutionFactory());
    }
    default <PARAM, B, C, D, E, F, G, H, I, RESULT> Supplier9ParamsBuilder<PARAM, B, C, D, E, F, G, H, I, RESULT> execute(NonaFunction<PARAM, B, C, D, E, F, G, H, I, RESULT> lambda) {
        return new Supplier9ParamsBuilder<>(lambda, buildExecutionFactory());
    }
    default <PARAM, B, C, D, E, F, G, H, RESULT> Supplier8ParamsBuilder<PARAM, B, C, D, E, F, G, H, RESULT> execute(OctaFunction<PARAM, B, C, D, E, F, G, H, RESULT> lambda) {
        return new Supplier8ParamsBuilder<>(lambda, buildExecutionFactory());
    }
    default <PARAM, B, C, D, E, F, G, RESULT> Supplier7ParamsBuilder<PARAM, B, C, D, E, F, G, RESULT> execute(HeptaFunction<PARAM, B, C, D, E, F, G, RESULT> lambda) {
        return new Supplier7ParamsBuilder<>(lambda, buildExecutionFactory());
    }
    default <PARAM, B, C, D, E, F, RESULT> Supplier6ParamsBuilder<PARAM, B, C, D, E, F, RESULT> execute(HexaFunction<PARAM, B, C, D, E, F, RESULT> lambda) {
        return new Supplier6ParamsBuilder<>(lambda, buildExecutionFactory());
    }
    default <PARAM, B, C, D, E, RESULT> Supplier5ParamsBuilder<PARAM, B, C, D, E, RESULT> execute(PentaFunction<PARAM, B, C, D, E, RESULT> lambda) {
        return new Supplier5ParamsBuilder<>(lambda, buildExecutionFactory());
    }
    default <PARAM, B, C, D, RESULT> Supplier4ParamsBuilder<PARAM, B, C, D, RESULT> execute(TetraFunction<PARAM, B, C, D, RESULT> lambda) {
        return new Supplier4ParamsBuilder<>(lambda, buildExecutionFactory());
    }
    default <PARAM, B, C, RESULT> Supplier3ParamsBuilder<PARAM, B, C, RESULT> execute(TriFunction<PARAM, B, C, RESULT> lambda) {
        return new Supplier3ParamsBuilder<>(lambda, buildExecutionFactory());
    }
    default <PARAM, B, RESULT> Supplier2ParamsBuilder<PARAM, B, RESULT> execute(BiFunction<PARAM, B, RESULT> lambda) {
        return new Supplier2ParamsBuilder<>(lambda, buildExecutionFactory());
    }
    default <PARAM, RESULT> Supplier1ParamBuilder<PARAM, RESULT> execute(Function<PARAM, RESULT> lambda) {
        return new Supplier1ParamBuilder<>(lambda, buildExecutionFactory());
    }
    default <RESULT> RESULT execute(Supplier<RESULT> lambda) {
        return buildExecutionFactory().create(lambda).execute();
    }
}
