package org.mule.commons.atlantic.execution.exception.handler;

/**
 * Concrete implementation of {@link ExceptionHandler} that contains the class of the {@link Throwable} handled.
 *
 * @param <T> The type of the {@link Throwable} handled.
 */
public class DefinedExceptionHandler<T extends Throwable> implements ExceptionHandler<T> {
    private final Class<T> handledException;
    private final ExceptionHandler<T> exceptionHandler;

    /**
     * Default constructor. Takes the class of the handled {@link Throwable} and an implementation of it's handler.
     *
     * @param handledException The class of the {@link Throwable} to handle.
     * @param exceptionHandler The handler itself.
     */
    public DefinedExceptionHandler(Class<T> handledException, ExceptionHandler<T> exceptionHandler) {
        this.handledException = handledException;
        this.exceptionHandler = exceptionHandler;
    }

    public Class<T> getHandledException() {
        return handledException;
    }

    @Override
    public void handle(Throwable throwable) {
        exceptionHandler.handle((T) throwable);
    }
}
