package org.mule.commons.atlantic.execution.exception.handler;

/**
 * Interface that describes a class that handles a determined type of exception thrown over an execution of an
 * {@link org.mule.commons.atlantic.lambda.AtlanticLambda}.
 *
 * @param <T> The type of {@link Throwable} handled.
 */
@FunctionalInterface
public interface ExceptionHandler<T extends Throwable> {

    /**
     * Handles the {@link Throwable}.
     *
     * @param throwable The throwable to handle.
     */
    void handle(T throwable);
}
