package org.mule.commons.atlantic.lambda.consumer;

import org.mule.commons.atlantic.lambda.function.Function;
import org.mule.commons.atlantic.lambda.runnable.Runnable;
import org.mule.commons.atlantic.lambda.supplier.Supplier;

/**
 * Represents an operation that accepts a single input argument and returns no result. Unlike most other functional
 * interfaces, {@code Consumer} is expected to operate via side-effects.
 *
 * This is a functional interface whose functional method is {@link #accept(Object)}.
 *
 * @param <A> The type of the input to the operation.
 */
@FunctionalInterface
public interface Consumer<A> extends AtlanticConsumer<A, Runnable, Function<A, Void>> {

    @Override
    default Runnable downgrade(Supplier<A> supplier) {
        return () -> accept(supplier.get());
    }

    /**
     * Performs this operation on the given argument.
     *
     * @param parameter The input argument.
     * @throws Throwable Any exception that the operation will throw.
     */
    void accept(A parameter) throws Throwable;

    @Override
    default Function<A, Void> toFunction() {
        return (a) -> {
            accept(a);
            return null;
        };
    }
}
