package org.mule.commons.atlantic.lambda.consumer;

import org.mule.commons.atlantic.lambda.function.NonaFunction;
import org.mule.commons.atlantic.lambda.supplier.Supplier;

/**
 * Represents an operation that accepts nine input arguments and returns no result.  This is the nine-arity
 * specialization of {@link Consumer}.
 * Unlike most other functional interfaces, {@code NonaConsumer} is expected to operate via side-effects.
 *
 * This is a functional interface whose functional method is {@link #accept(Object, Object, Object, Object, Object, Object, Object, Object, Object)}.
 *
 * @param <A> The type of the first argument to the operation.
 * @param <B> The type of the second argument to the operation.
 * @param <C> The type of the third argument to the operation.
 * @param <D> The type of the fourth argument to the operation.
 * @param <E> The type of the fifth argument to the operation.
 * @param <F> The type of the sixth argument to the operation.
 * @param <G> The type of the seventh argument to the operation.
 * @param <H> The type of the eighth argument to the operation.
 * @param <I> The type of the ninth argument to the operation.
 */
@FunctionalInterface
public interface NonaConsumer<A, B, C, D, E, F, G, H, I> extends AtlanticConsumer<A, OctaConsumer<B, C, D, E, F, G, H, I>, NonaFunction<A, B, C, D, E, F, G, H, I, Void>> {

    @Override
    default OctaConsumer<B, C, D, E, F, G, H, I> downgrade(Supplier<A> supplier) {
        return (b, c, d, e, f, g, h, i) -> accept(supplier.get(), b, c, d, e, f, g, h, i);
    }

    /**
     * Performs this operation on the given arguments.
     *
     * @param a The first input argument.
     * @param b The second input argument.
     * @param c The third input argument.
     * @param d The fourth input argument.
     * @param e The fifth input argument.
     * @param f The sixth input argument.
     * @param g The seventh input argument.
     * @param h The eighth input argument.
     * @param i The ninth input argument.
     * @throws Throwable Any exception that the operation will throw.
     */
    void accept(A a, B b, C c, D d, E e, F f, G g, H h, I i) throws Throwable;

    @Override
    default NonaFunction<A, B, C, D, E, F, G, H, I, Void> toFunction() {
        return (a, b, c, d, e, f, g, h, i) -> {
            accept(a, b, c, d, e, f, g, h, i);
            return null;
        };
    }
}
