/*
 * Copyright 2023 Salesforce, Inc. All rights reserved.
 * The software in this package is published under the terms of the CPAL v1.0
 * license, a copy of which has been included with this distribution in the
 * LICENSE.txt file.
 */
package org.mule.oauth.client.api.exception;

import org.mule.runtime.api.exception.MuleException;
import org.mule.runtime.api.i18n.I18nMessage;

/**
 * Exception throw when it's not possible to create the authentication request for a given request.
 *
 * @since 1.0
 */
public final class RequestAuthenticationException extends MuleException {

  private static final long serialVersionUID = 5053323135035970693L;

  public RequestAuthenticationException(I18nMessage message) {
    super(message);
  }

}
