/*
 * Copyright 2023 Salesforce, Inc. All rights reserved.
 * The software in this package is published under the terms of the CPAL v1.0
 * license, a copy of which has been included with this distribution in the
 * LICENSE.txt file.
 */
package org.mule.oauth.client.api.listener;

/**
 * Allows to get notified about events related to the state of an OAuth authorization
 *
 * @since 1.0
 */
public interface OAuthStateListener {

  /**
   * Invoked when a tokens gets invalidated by a Mule application. Not to be confused with revocation at the service provider's
   * end.
   */
  default void onTokenInvalidated() {

  }
}
