/*
 * Copyright (c) MuleSoft, Inc.  All rights reserved.  http://www.mulesoft.com
 * The software in this package is published under the terms of the CPAL v1.0
 * license, a copy of which has been included with this distribution in the
 * LICENSE.txt file.
 */
package org.mule.runtime.oauth.api.http;

import org.mule.runtime.oauth.internal.http.DefaultHttpClientFactory;
import org.mule.runtime.api.tls.TlsContextFactory;
import org.mule.runtime.http.api.HttpService;
import org.mule.runtime.http.api.client.HttpClient;
import org.mule.runtime.http.api.client.proxy.ProxyConfig;

/**
 *  Factory object for {@link HttpClient}.
 *
 * @since 1.0
 */
public interface HttpClientFactory {

  /**
   * Provides a default implementation of the {@link HttpClientFactory}
   *
   * @param httpService the {@link HttpService} needed to create a new {@link HttpClient} instance
   * @return a default implementation of the {@link HttpClientFactory}
   */
  static HttpClientFactory getDefault(HttpService httpService) {
    return new DefaultHttpClientFactory(httpService);
  }

  /**
   * @param tlsContextFactory the {@link TlsContextFactory} required exclusively for HTTPS
   * @param proxyConfig the {@link ProxyConfig} required when connecting through a proxy,
   *
   * @return a newly built {@link HttpClient} based on the {@code tlsContextFactory} and {@code proxyConfig}.
   */
  HttpClient create(TlsContextFactory tlsContextFactory, ProxyConfig proxyConfig);
}
