/*
 * Copyright (c) MuleSoft, Inc.  All rights reserved.  http://www.mulesoft.com
 * The software in this package is published under the terms of the CPAL v1.0
 * license, a copy of which has been included with this distribution in the
 * LICENSE.txt file.
 */
package org.mule.runtime.oauth.internal.config;

import org.mule.runtime.http.api.server.HttpServer;
import org.mule.runtime.oauth.api.AuthorizationCodeRequest;
import org.mule.runtime.oauth.api.builder.AuthorizationCodeDanceCallbackContext;
import org.mule.runtime.oauth.api.state.ResourceOwnerOAuthContext;

import java.util.Map;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import java.util.function.Supplier;

/**
 * Set of attributes needed to create authorization-code dancer {@link org.mule.runtime.oauth.internal.DefaultAuthorizationCodeOAuthDancer}.
 *
 * @since 1.0
 */
public class DefaultAuthorizationCodeOAuthDancerConfig extends OAuthDancerConfig {

  private Optional<HttpServer> httpServer;

  private String localCallbackUrlPath;

  private String localAuthorizationUrlPath;
  private String localAuthorizationUrlResourceOwnerId;

  private String externalCallbackUrl;

  private String state;
  private String authorizationUrl;

  private Supplier<Map<String, String>> customParameters;
  private Supplier<Map<String, String>> customHeaders;

  private Function<AuthorizationCodeRequest, AuthorizationCodeDanceCallbackContext> beforeDanceCallback;
  private BiConsumer<AuthorizationCodeDanceCallbackContext, ResourceOwnerOAuthContext> afterDanceCallback;

  public Optional<HttpServer> getHttpServer() {
    return httpServer;
  }

  public void setHttpServer(Optional<HttpServer> httpServer) {
    this.httpServer = httpServer;
  }

  public String getLocalCallbackUrlPath() {
    return localCallbackUrlPath;
  }

  public void setLocalCallbackUrlPath(String localCallbackUrlPath) {
    this.localCallbackUrlPath = localCallbackUrlPath;
  }

  public String getLocalAuthorizationUrlPath() {
    return localAuthorizationUrlPath;
  }

  public void setLocalAuthorizationUrlPath(String localAuthorizationUrlPath) {
    this.localAuthorizationUrlPath = localAuthorizationUrlPath;
  }

  public String getLocalAuthorizationUrlResourceOwnerId() {
    return localAuthorizationUrlResourceOwnerId;
  }

  public void setLocalAuthorizationUrlResourceOwnerId(String localAuthorizationUrlResourceOwnerId) {
    this.localAuthorizationUrlResourceOwnerId = localAuthorizationUrlResourceOwnerId;
  }

  public String getExternalCallbackUrl() {
    return externalCallbackUrl;
  }

  public void setExternalCallbackUrl(String externalCallbackUrl) {
    this.externalCallbackUrl = externalCallbackUrl;
  }

  public String getState() {
    return state;
  }

  public void setState(String state) {
    this.state = state;
  }

  public String getAuthorizationUrl() {
    return authorizationUrl;
  }

  public void setAuthorizationUrl(String authorizationUrl) {
    this.authorizationUrl = authorizationUrl;
  }

  public Supplier<Map<String, String>> getCustomParameters() {
    return customParameters;
  }

  public void setCustomParameters(Supplier<Map<String, String>> customParameters) {
    this.customParameters = customParameters;
  }

  public Supplier<Map<String, String>> getCustomHeaders() {
    return customHeaders;
  }

  public void setCustomHeaders(Supplier<Map<String, String>> customHeaders) {
    this.customHeaders = customHeaders;
  }

  public Function<AuthorizationCodeRequest, AuthorizationCodeDanceCallbackContext> getBeforeDanceCallback() {
    return beforeDanceCallback;
  }

  public void setBeforeDanceCallback(Function<AuthorizationCodeRequest, AuthorizationCodeDanceCallbackContext> beforeDanceCallback) {
    this.beforeDanceCallback = beforeDanceCallback;
  }

  public BiConsumer<AuthorizationCodeDanceCallbackContext, ResourceOwnerOAuthContext> getAfterDanceCallback() {
    return afterDanceCallback;
  }

  public void setAfterDanceCallback(BiConsumer<AuthorizationCodeDanceCallbackContext, ResourceOwnerOAuthContext> afterDanceCallback) {
    this.afterDanceCallback = afterDanceCallback;
  }
}
