/*
 * Decompiled with CFR 0.152.
 */
package org.mule.runtime.test.oauth.http;

import io.qameta.allure.Feature;
import io.qameta.allure.Story;
import org.hamcrest.Matcher;
import org.hamcrest.Matchers;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;
import org.mockito.ArgumentMatchers;
import org.mockito.Mockito;
import org.mule.runtime.api.tls.TlsContextFactory;
import org.mule.runtime.http.api.HttpService;
import org.mule.runtime.http.api.client.HttpClient;
import org.mule.runtime.http.api.client.HttpClientConfiguration;
import org.mule.runtime.http.api.client.proxy.ProxyConfig;
import org.mule.runtime.oauth.api.http.HttpClientFactory;
import org.mule.runtime.oauth.internal.http.DefaultHttpClientFactory;

@Feature(value="OAuth Client")
@Story(value="OAuth Dancer")
public class DefaultHttpClientFactoryTestCase {
    private TlsContextFactory tlsContextFactory;
    private ProxyConfig proxyConfig;
    private HttpClientFactory oAuthHttpClientFactory;

    @Before
    public void setup() {
        this.tlsContextFactory = (TlsContextFactory)Mockito.mock(TlsContextFactory.class);
        this.proxyConfig = (ProxyConfig)Mockito.mock(ProxyConfig.class);
        org.mule.runtime.http.api.client.HttpClientFactory httpClientFactory = (org.mule.runtime.http.api.client.HttpClientFactory)Mockito.mock(org.mule.runtime.http.api.client.HttpClientFactory.class);
        HttpClient httpClient = (HttpClient)Mockito.mock(HttpClient.class);
        Mockito.when((Object)httpClientFactory.create((HttpClientConfiguration)ArgumentMatchers.any())).thenReturn((Object)httpClient);
        HttpService httpService = (HttpService)Mockito.mock(HttpService.class);
        Mockito.when((Object)httpService.getClientFactory()).thenReturn((Object)httpClientFactory);
        this.oAuthHttpClientFactory = new DefaultHttpClientFactory(httpService);
    }

    @Test
    public void createHttpClientWithSameParameterReturnCachedHttpClient() {
        HttpClient client = this.oAuthHttpClientFactory.create(this.tlsContextFactory, this.proxyConfig);
        Assert.assertThat((Object)client, (Matcher)Matchers.is((Matcher)Matchers.notNullValue()));
        HttpClient cachedHttpClient = this.oAuthHttpClientFactory.create(this.tlsContextFactory, this.proxyConfig);
        Assert.assertThat((Object)cachedHttpClient, (Matcher)Matchers.is((Object)client));
    }

    @Test
    public void createHttpClientWithDifferentParametersReturnCachedHttpClient() {
        HttpClient client = this.oAuthHttpClientFactory.create(this.tlsContextFactory, this.proxyConfig);
        Assert.assertThat((Object)client, (Matcher)Matchers.is((Matcher)Matchers.notNullValue()));
        HttpClient cachedHttpClient = this.oAuthHttpClientFactory.create(null, null);
        Assert.assertThat((Object)cachedHttpClient, (Matcher)Matchers.is((Matcher)Matchers.not((Object)client)));
        cachedHttpClient = this.oAuthHttpClientFactory.create(this.tlsContextFactory, null);
        Assert.assertThat((Object)cachedHttpClient, (Matcher)Matchers.is((Matcher)Matchers.not((Object)client)));
        cachedHttpClient = this.oAuthHttpClientFactory.create(null, this.proxyConfig);
        Assert.assertThat((Object)cachedHttpClient, (Matcher)Matchers.is((Matcher)Matchers.not((Object)client)));
        cachedHttpClient = this.oAuthHttpClientFactory.create((TlsContextFactory)Mockito.mock(TlsContextFactory.class), this.proxyConfig);
        Assert.assertThat((Object)cachedHttpClient, (Matcher)Matchers.is((Matcher)Matchers.not((Object)client)));
    }

    @Test
    public void stoppingCachedHttpClientShouldReturnANewHttpClient() {
        HttpClient client = this.oAuthHttpClientFactory.create(this.tlsContextFactory, this.proxyConfig);
        Assert.assertThat((Object)client, (Matcher)Matchers.is((Matcher)Matchers.notNullValue()));
        HttpClient cachedHttpClient = this.oAuthHttpClientFactory.create(this.tlsContextFactory, this.proxyConfig);
        Assert.assertThat((Object)cachedHttpClient, (Matcher)Matchers.is((Object)client));
        client.start();
        client.stop();
        cachedHttpClient = this.oAuthHttpClientFactory.create(this.tlsContextFactory, this.proxyConfig);
        Assert.assertThat((Object)cachedHttpClient, (Matcher)Matchers.is((Matcher)Matchers.not((Object)client)));
    }
}

