/*
 * Copyright (c) MuleSoft, Inc.  All rights reserved.  http://www.mulesoft.com
 * The software in this package is published under the terms of the CPAL v1.0
 * license, a copy of which has been included with this distribution in the
 * LICENSE.txt file.
 */
package org.mule.runtime.oauth.api.builder;

import org.mule.api.annotation.NoImplement;
import org.mule.runtime.oauth.api.ClientCredentialsOAuthDancer;
import org.mule.runtime.oauth.api.listener.ClientCredentialsListener;

import java.util.Map;

/**
 * Builder that allows to configure the attributes for the client credentials grant type.
 *
 * @since 1.0
 */
@NoImplement
public interface OAuthClientCredentialsDancerBuilder extends OAuthDancerBuilder<ClientCredentialsOAuthDancer> {

  /**
   * There are OAuth implementations that require or allow extra query parameters to be sent when calling the token URL of the
   * OAS.
   *
   * @param customParameters a {@link Map} the extra parameters to be sent with the token request to {@link #tokenUrl(String)}.
   * @return this builder
   */
  OAuthClientCredentialsDancerBuilder customParameters(Map<String, String> customParameters);

  /**
   * There are OAuth implementations that require or allow extra headers to be sent when calling the token URL of the OAS.
   *
   * @param customHeaders a {@link Map} the extra headers to be sent with the token request to {@link #tokenUrl(String)}.
   * @return this builder
   */
  OAuthClientCredentialsDancerBuilder customHeaders(Map<String, String> customHeaders);

  /**
   * Adds the {@code listener}. Listeners will be invoked in the same order as they were added
   *
   * @param listener the {@link ClientCredentialsListener} to be added
   * @throws IllegalArgumentException if the {@code listener} is {@code null}
   */
  OAuthClientCredentialsDancerBuilder addListener(ClientCredentialsListener listener);

  /**
   * @param encodeClientCredentialsInBody If @{code true}, the client id and client secret will be sent in the request body.
   *                                      Otherwise, they will be sent as basic authentication.
   * @return this builder
   * @deprecated since 4.2.0. Use {@link OAuthClientCredentialsDancerBuilder#withClientCredentialsIn(ClientCredentialsLocation)}
   *             instead.
   */
  @Deprecated
  OAuthClientCredentialsDancerBuilder encodeClientCredentialsInBody(boolean encodeClientCredentialsInBody);

}
