/*
 * Decompiled with CFR 0.152.
 */
package org.mule.runtime.oauth.internal;

import java.io.IOException;
import java.io.InputStream;
import java.nio.charset.Charset;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.CompletionException;
import java.util.concurrent.CopyOnWriteArrayList;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.locks.Lock;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.function.Supplier;
import org.apache.commons.codec.binary.Base64;
import org.mule.runtime.api.el.BindingContext;
import org.mule.runtime.api.exception.MuleException;
import org.mule.runtime.api.exception.MuleRuntimeException;
import org.mule.runtime.api.i18n.I18nMessageFactory;
import org.mule.runtime.api.lifecycle.Startable;
import org.mule.runtime.api.lifecycle.Stoppable;
import org.mule.runtime.api.lock.LockFactory;
import org.mule.runtime.api.metadata.DataType;
import org.mule.runtime.api.metadata.MediaType;
import org.mule.runtime.api.metadata.TypedValue;
import org.mule.runtime.api.scheduler.Scheduler;
import org.mule.runtime.api.scheduler.SchedulerConfig;
import org.mule.runtime.api.util.MultiMap;
import org.mule.runtime.api.util.Preconditions;
import org.mule.runtime.http.api.HttpConstants;
import org.mule.runtime.http.api.HttpHeaders;
import org.mule.runtime.http.api.client.HttpRequestOptions;
import org.mule.runtime.http.api.domain.entity.ByteArrayHttpEntity;
import org.mule.runtime.http.api.domain.entity.HttpEntity;
import org.mule.runtime.http.api.domain.message.request.HttpRequest;
import org.mule.runtime.http.api.domain.message.request.HttpRequestBuilder;
import org.mule.runtime.http.api.domain.message.response.HttpResponse;
import org.mule.runtime.http.api.utils.HttpEncoderDecoderUtils;
import org.mule.runtime.oauth.api.builder.ClientCredentialsLocation;
import org.mule.runtime.oauth.api.exception.TokenNotFoundException;
import org.mule.runtime.oauth.api.exception.TokenUrlResponseException;
import org.mule.runtime.oauth.api.listener.OAuthStateListener;
import org.mule.runtime.oauth.api.state.DancerState;
import org.mule.runtime.oauth.api.state.ResourceOwnerOAuthContext;
import org.mule.runtime.oauth.api.state.ResourceOwnerOAuthContextWithRefreshState;
import org.mule.runtime.oauth.internal.config.OAuthDancerConfig;
import org.mule.runtime.oauth.internal.state.TokenResponse;
import org.mule.runtime.oauth.internal.util.ClassLoaderUtils;
import org.mule.runtime.oauth.internal.util.IOUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class AbstractOAuthDancer<T extends OAuthDancerConfig>
implements Startable,
Stoppable {
    private static final Logger LOGGER = LoggerFactory.getLogger(AbstractOAuthDancer.class);
    public static final int TOKEN_REQUEST_TIMEOUT_MILLIS = 60000;
    protected final T config;
    private final List<OAuthStateListener> listeners;
    private Scheduler pollScheduler;

    protected AbstractOAuthDancer(T config) {
        this.config = config;
        this.listeners = ((OAuthDancerConfig)config).getListeners() != null ? new CopyOnWriteArrayList<OAuthStateListener>(((OAuthDancerConfig)config).getListeners()) : new CopyOnWriteArrayList<OAuthStateListener>();
    }

    public void start() throws MuleException {
        this.startHttpClient();
        this.pollScheduler = ((OAuthDancerConfig)this.config).getSchedulerService().ioScheduler(SchedulerConfig.config().withName(((OAuthDancerConfig)this.config).getName() + "-oauthDancer-tokenRefreshPoll").withShutdownTimeout(0L, TimeUnit.MILLISECONDS));
    }

    protected void startHttpClient() {
        ((OAuthDancerConfig)this.config).getHttpClient().start();
    }

    public void stop() throws MuleException {
        try {
            if (this.pollScheduler != null) {
                this.pollScheduler.stop();
            }
        }
        catch (Throwable t) {
            LOGGER.warn("Found error trying to stop pollScheduler for dancer '" + ((OAuthDancerConfig)this.config).getName() + "'. Execution will continue...", t);
        }
        this.stopHttpClient();
    }

    protected void stopHttpClient() {
        ((OAuthDancerConfig)this.config).getHttpClient().stop();
    }

    protected String handleClientCredentials(Map<String, String> formData) {
        switch (((OAuthDancerConfig)this.config).getCredentialConfig().getClientCredentialsLocation()) {
            case BASIC_AUTH_HEADER: {
                return "Basic " + Base64.encodeBase64String((byte[])String.format("%s:%s", ((OAuthDancerConfig)this.config).getCredentialConfig().getClientId(), ((OAuthDancerConfig)this.config).getCredentialConfig().getClientSecret()).getBytes());
            }
            case BODY: {
                formData.put("client_id", ((OAuthDancerConfig)this.config).getCredentialConfig().getClientId());
                formData.put("client_secret", ((OAuthDancerConfig)this.config).getCredentialConfig().getClientSecret());
            }
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected <T> CompletableFuture<T> doRefreshToken(Supplier<ResourceOwnerOAuthContext> oauthContextSupplier, Function<ResourceOwnerOAuthContext, CompletableFuture<T>> tokenRefreshRequester) {
        Lock lock;
        ResourceOwnerOAuthContext oauthContext;
        block21: {
            oauthContext = oauthContextSupplier.get();
            lock = oauthContext.getRefreshOAuthContextLock(((OAuthDancerConfig)this.config).getName(), this.getLockProvider());
            if (oauthContext.getDancerState() == DancerState.NO_TOKEN) {
                if (lock.tryLock()) {
                    try {
                        oauthContext = oauthContextSupplier.get();
                        if (oauthContext.getDancerState() == DancerState.HAS_TOKEN) {
                            CompletableFuture<Object> completableFuture = CompletableFuture.completedFuture(null);
                            return completableFuture;
                        }
                        if (oauthContext.getDancerState() == DancerState.REFRESHING_TOKEN) {
                            CompletableFuture<T> completableFuture = this.pollForRefreshComplete(oauthContextSupplier, oauthContext);
                            return completableFuture;
                        }
                        if (oauthContext.getDancerState() == DancerState.NO_TOKEN) {
                            CompletableFuture<T> completableFuture = this.doRefreshTokenRequest(tokenRefreshRequester, oauthContext);
                            return completableFuture;
                        }
                        break block21;
                    }
                    finally {
                        lock.unlock();
                    }
                }
                return this.pollForRefreshComplete(oauthContextSupplier, oauthContext);
            }
        }
        if (oauthContext.getDancerState() == DancerState.HAS_TOKEN) {
            String accessToken = oauthContext.getAccessToken();
            lock.lock();
            try {
                oauthContext = oauthContextSupplier.get();
                if (oauthContext.getDancerState() == DancerState.HAS_TOKEN) {
                    if (accessToken.equals(oauthContext.getAccessToken())) {
                        CompletableFuture<T> completableFuture = this.doRefreshTokenRequest(tokenRefreshRequester, oauthContext);
                        return completableFuture;
                    }
                    CompletableFuture<Object> completableFuture = CompletableFuture.completedFuture(null);
                    return completableFuture;
                }
                if (oauthContext.getDancerState() == DancerState.REFRESHING_TOKEN) {
                    CompletableFuture<T> completableFuture = this.pollForRefreshComplete(oauthContextSupplier, oauthContext);
                    return completableFuture;
                }
                if (oauthContext.getDancerState() == DancerState.NO_TOKEN) {
                    CompletableFuture<T> completableFuture = this.doRefreshTokenRequest(tokenRefreshRequester, oauthContext);
                    return completableFuture;
                }
            }
            finally {
                lock.unlock();
            }
        }
        return this.pollForRefreshComplete(oauthContextSupplier, oauthContext);
    }

    protected <T> CompletableFuture<T> doRefreshTokenRequest(Function<ResourceOwnerOAuthContext, CompletableFuture<T>> tokenRefreshRequester, ResourceOwnerOAuthContext oauthContext) {
        oauthContext.setDancerState(DancerState.REFRESHING_TOKEN);
        this.updateResourceOwnerOAuthContext(oauthContext);
        try {
            return tokenRefreshRequester.apply(oauthContext);
        }
        catch (Exception e) {
            oauthContext.setDancerState(DancerState.NO_TOKEN);
            this.updateResourceOwnerOAuthContext(oauthContext);
            throw e;
        }
    }

    private <T> CompletableFuture<T> pollForRefreshComplete(Supplier<ResourceOwnerOAuthContext> oauthContextSupplier, ResourceOwnerOAuthContext oauthContext) {
        CompletableFuture pendingResponse = new CompletableFuture();
        this.pollScheduler.execute(() -> {
            long startNanos = System.nanoTime();
            ResourceOwnerOAuthContext ctx = (ResourceOwnerOAuthContext)oauthContextSupplier.get();
            while (ctx.getDancerState() == DancerState.REFRESHING_TOKEN) {
                if (TimeUnit.NANOSECONDS.toMillis(System.nanoTime() - startNanos) > 60000L) {
                    oauthContext.setDancerState(DancerState.NO_TOKEN);
                    this.updateResourceOwnerOAuthContext(oauthContext);
                    pendingResponse.completeExceptionally((Throwable)new MuleRuntimeException(I18nMessageFactory.createStaticMessage((String)"Timeout polling for token refresh to complete.")));
                }
                try {
                    Thread.sleep(100L);
                }
                catch (InterruptedException e) {
                    Thread.currentThread().interrupt();
                    pendingResponse.completeExceptionally(e);
                }
                ctx = (ResourceOwnerOAuthContext)oauthContextSupplier.get();
            }
            pendingResponse.complete(null);
        });
        return pendingResponse;
    }

    protected CompletableFuture<TokenResponse> invokeTokenUrl(String tokenUrl, Map<String, String> tokenRequestFormToSend, MultiMap<String, String> queryParams, MultiMap<String, String> headers, String authorization, boolean retrieveRefreshToken, Charset encoding) {
        HttpRequestBuilder requestBuilder = (HttpRequestBuilder)((HttpRequestBuilder)((HttpRequestBuilder)HttpRequest.builder().uri(tokenUrl).method(HttpConstants.Method.POST.name()).entity((HttpEntity)new ByteArrayHttpEntity(HttpEncoderDecoderUtils.encodeString(tokenRequestFormToSend, (Charset)encoding).getBytes()))).addHeader("Content-Type", HttpHeaders.Values.APPLICATION_X_WWW_FORM_URLENCODED.toRfcString())).queryParams(queryParams).headers(headers);
        if (authorization != null) {
            requestBuilder.addHeader("Authorization", authorization);
        } else if (ClientCredentialsLocation.QUERY_PARAMS.equals((Object)((OAuthDancerConfig)this.config).getCredentialConfig().getClientCredentialsLocation())) {
            requestBuilder.addQueryParam("client_id", ((OAuthDancerConfig)this.config).getCredentialConfig().getClientId());
            requestBuilder.addQueryParam("client_secret", ((OAuthDancerConfig)this.config).getCredentialConfig().getClientSecret());
        }
        return ((CompletableFuture)((OAuthDancerConfig)this.config).getHttpClient().sendAsync(requestBuilder.build(), HttpRequestOptions.builder().responseTimeout(60000).build()).exceptionally(t -> {
            Thread thread = Thread.currentThread();
            ClassLoader currentClassLoader = thread.getContextClassLoader();
            ClassLoader contextClassLoader = AbstractOAuthDancer.class.getClassLoader();
            ClassLoaderUtils.setContextClassLoader(thread, currentClassLoader, contextClassLoader);
            try {
                if (t instanceof IOException) {
                    throw new CompletionException((Throwable)((Object)new TokenUrlResponseException(tokenUrl, (IOException)t)));
                }
                throw new CompletionException((Throwable)t);
            }
            catch (Throwable throwable) {
                ClassLoaderUtils.setContextClassLoader(thread, contextClassLoader, currentClassLoader);
                throw throwable;
            }
        })).thenApply(response -> this.parseTokenResponse((HttpResponse)response, tokenUrl, retrieveRefreshToken));
    }

    protected TokenResponse parseTokenResponse(HttpResponse response, String tokenUrl, boolean retrieveRefreshToken) {
        Thread thread = Thread.currentThread();
        ClassLoader currentClassLoader = thread.getContextClassLoader();
        ClassLoader contextClassLoader = AbstractOAuthDancer.class.getClassLoader();
        ClassLoaderUtils.setContextClassLoader(thread, currentClassLoader, contextClassLoader);
        try {
            String body;
            String contentType = response.getHeaderValue("Content-Type");
            MediaType responseContentType = contentType != null ? MediaType.parse((String)contentType) : MediaType.ANY;
            try (InputStream content = response.getEntity().getContent();){
                body = IOUtils.toString(content);
                if (response.getStatusCode() >= HttpConstants.HttpStatus.BAD_REQUEST.getStatusCode()) {
                    try {
                        throw new CompletionException((Throwable)((Object)new TokenUrlResponseException(tokenUrl, response, body)));
                    }
                    catch (IOException e) {
                        throw new CompletionException((Throwable)((Object)new TokenUrlResponseException(tokenUrl, e)));
                    }
                }
            }
            MultiMap responseHeaders = response.getHeaders();
            TokenResponse tokenResponse = new TokenResponse();
            tokenResponse.setAccessToken((String)this.resolveExpression(((OAuthDancerConfig)this.config).getTokenParserConfig().getResponseAccessTokenExpr(), body, (MultiMap<String, String>)responseHeaders, responseContentType));
            if (tokenResponse.getAccessToken() == null) {
                throw new CompletionException((Throwable)((Object)new TokenNotFoundException(tokenUrl, response, body)));
            }
            if (retrieveRefreshToken) {
                tokenResponse.setRefreshToken((String)this.resolveExpression(((OAuthDancerConfig)this.config).getTokenParserConfig().getResponseRefreshTokenExpr(), body, (MultiMap<String, String>)responseHeaders, responseContentType));
            }
            tokenResponse.setExpiresIn((String)this.resolveExpression(((OAuthDancerConfig)this.config).getTokenParserConfig().getResponseExpiresInExpr(), body, (MultiMap<String, String>)responseHeaders, responseContentType));
            if (((OAuthDancerConfig)this.config).getCustomParametersExtractorsExprs() != null && !((OAuthDancerConfig)this.config).getCustomParametersExtractorsExprs().isEmpty()) {
                HashMap<String, Object> customParams = new HashMap<String, Object>();
                for (Map.Entry<String, String> customParamExpr : ((OAuthDancerConfig)this.config).getCustomParametersExtractorsExprs().entrySet()) {
                    customParams.put(customParamExpr.getKey(), this.resolveExpression(customParamExpr.getValue(), body, (MultiMap<String, String>)responseHeaders, responseContentType));
                }
                tokenResponse.setCustomResponseParameters(customParams);
            }
            TokenResponse tokenResponse2 = tokenResponse;
            return tokenResponse2;
        }
        catch (Exception e) {
            if (e instanceof RuntimeException) {
                throw (RuntimeException)e;
            }
            throw new MuleRuntimeException((Throwable)e);
        }
        finally {
            ClassLoaderUtils.setContextClassLoader(thread, contextClassLoader, currentClassLoader);
        }
    }

    protected void updateOAuthContextAfterTokenResponse(ResourceOwnerOAuthContext defaultUserState) {
        defaultUserState.setDancerState(DancerState.HAS_TOKEN);
        this.updateResourceOwnerOAuthContext(defaultUserState);
    }

    protected <T> Function<Throwable, ? extends T> tokenUrlExceptionHandler(ResourceOwnerOAuthContext defaultUserState) {
        return t -> {
            defaultUserState.setDancerState(DancerState.NO_TOKEN);
            this.updateResourceOwnerOAuthContext(defaultUserState);
            if (t instanceof CompletionException) {
                throw (CompletionException)t;
            }
            throw new CompletionException((Throwable)t);
        };
    }

    protected <T> T resolveExpression(String expr, Object body, MultiMap<String, String> headers, MediaType responseContentType) {
        if (expr == null) {
            return null;
        }
        if (!((OAuthDancerConfig)this.config).getExpressionEvaluator().isExpression(expr)) {
            return (T)expr;
        }
        BindingContext resultContext = BindingContext.builder().addBinding("payload", new TypedValue(body, DataType.builder().fromObject(body).mediaType(responseContentType).build())).addBinding("attributes", new TypedValue(Collections.singletonMap("headers", headers.toImmutableMultiMap()), DataType.fromType(Map.class))).addBinding("dataType", new TypedValue((Object)DataType.builder().fromObject(body).mediaType(responseContentType).build(), DataType.fromType(DataType.class))).build();
        return (T)((OAuthDancerConfig)this.config).getExpressionEvaluator().evaluate(expr, DataType.STRING, resultContext).getValue();
    }

    protected <T> T resolveExpression(String expr, Object body, MultiMap<String, String> headers, MultiMap<String, String> queryParams, MediaType responseContentType) {
        if (expr == null) {
            return null;
        }
        if (!((OAuthDancerConfig)this.config).getExpressionEvaluator().isExpression(expr)) {
            return (T)expr;
        }
        HashMap<String, MultiMap> attributes = new HashMap<String, MultiMap>(2);
        attributes.put("headers", headers.toImmutableMultiMap());
        attributes.put("queryParams", queryParams.toImmutableMultiMap());
        BindingContext resultContext = BindingContext.builder().addBinding("payload", new TypedValue(body, DataType.builder().fromObject(body).mediaType(responseContentType).build())).addBinding("attributes", new TypedValue(attributes, DataType.fromType(Map.class))).addBinding("dataType", new TypedValue((Object)DataType.builder().fromObject(body).mediaType(responseContentType).build(), DataType.fromType(DataType.class))).build();
        return (T)((OAuthDancerConfig)this.config).getExpressionEvaluator().evaluate(expr, DataType.STRING, resultContext).getValue();
    }

    public void invalidateContext(String resourceOwner) {
        Lock refreshUserOAuthContextLock = this.getContextForResourceOwner(resourceOwner).getRefreshOAuthContextLock(((OAuthDancerConfig)this.config).getName(), this.getLockProvider());
        refreshUserOAuthContextLock.lock();
        try {
            ((OAuthDancerConfig)this.config).getTokensStore().remove(((OAuthDancerConfig)this.config).getResourceOwnerIdTransformer().apply(resourceOwner));
            this.onEachListener(OAuthStateListener::onTokenInvalidated);
        }
        finally {
            refreshUserOAuthContextLock.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public ResourceOwnerOAuthContext getContextForResourceOwner(String resourceOwnerId) {
        if (resourceOwnerId == null) {
            resourceOwnerId = "default";
        }
        String transformedResourceOwnerId = ((OAuthDancerConfig)this.config).getResourceOwnerIdTransformer().apply(resourceOwnerId);
        ResourceOwnerOAuthContext resourceOwnerOAuthContext = ((OAuthDancerConfig)this.config).getTokensStore().get(transformedResourceOwnerId);
        if (resourceOwnerOAuthContext != null) {
            if (resourceOwnerOAuthContext instanceof ResourceOwnerOAuthContextWithRefreshState) {
                return resourceOwnerOAuthContext;
            }
            return new ResourceOwnerOAuthContextWithRefreshState(resourceOwnerOAuthContext);
        }
        Lock lock = ResourceOwnerOAuthContextWithRefreshState.createRefreshOAuthContextLock(((OAuthDancerConfig)this.config).getName(), ((OAuthDancerConfig)this.config).getLockProvider(), resourceOwnerId);
        lock.lock();
        try {
            if (!((OAuthDancerConfig)this.config).getTokensStore().containsKey(transformedResourceOwnerId)) {
                resourceOwnerOAuthContext = new ResourceOwnerOAuthContextWithRefreshState(resourceOwnerId);
                ((OAuthDancerConfig)this.config).getTokensStore().put(transformedResourceOwnerId, resourceOwnerOAuthContext);
            } else {
                resourceOwnerOAuthContext = ((OAuthDancerConfig)this.config).getTokensStore().get(transformedResourceOwnerId);
            }
        }
        finally {
            lock.unlock();
        }
        return resourceOwnerOAuthContext;
    }

    protected void updateResourceOwnerOAuthContext(ResourceOwnerOAuthContext resourceOwnerOAuthContext) {
        Lock resourceOwnerContextLock = resourceOwnerOAuthContext.getRefreshOAuthContextLock(((OAuthDancerConfig)this.config).getName(), this.getLockProvider());
        resourceOwnerContextLock.lock();
        try {
            ((OAuthDancerConfig)this.config).getTokensStore().put(((OAuthDancerConfig)this.config).getResourceOwnerIdTransformer().apply(resourceOwnerOAuthContext.getResourceOwnerId()), resourceOwnerOAuthContext);
        }
        finally {
            resourceOwnerContextLock.unlock();
        }
    }

    protected LockFactory getLockProvider() {
        return ((OAuthDancerConfig)this.config).getLockProvider();
    }

    protected void doAddListener(OAuthStateListener listener) {
        Preconditions.checkArgument((listener != null ? 1 : 0) != 0, (String)"Cannot add a null listener");
        this.listeners.add(listener);
    }

    protected void doRemoveListener(OAuthStateListener listener) {
        Preconditions.checkArgument((listener != null ? 1 : 0) != 0, (String)"Cannot remove a null listener");
        this.listeners.remove(listener);
    }

    protected void onEachListener(Consumer<OAuthStateListener> action) {
        this.listeners.forEach(listener -> {
            block2: {
                try {
                    action.accept((OAuthStateListener)listener);
                }
                catch (Exception e) {
                    if (!LOGGER.isErrorEnabled()) break block2;
                    LOGGER.error(String.format("Exception found while invoking [%s] on OAuth dancer [%s]", this, listener), (Throwable)e);
                }
            }
        });
    }
}

