/*
 * Copyright (c) MuleSoft, Inc.  All rights reserved.  http://www.mulesoft.com
 * The software in this package is published under the terms of the CPAL v1.0
 * license, a copy of which has been included with this distribution in the
 * LICENSE.txt file.
 */
package org.mule.runtime.oauth.internal.config;

import org.mule.runtime.api.util.MultiMap;

/**
 * Set of attributes needed to create client credentials dancer
 * {@link org.mule.runtime.oauth.internal.DefaultClientCredentialsOAuthDancer}.
 *
 * @since 1.0
 */
public class DefaultClientCredentialsOAuthDancerConfig extends OAuthDancerConfig {

  private MultiMap<String, String> customParameters;
  private MultiMap<String, String> customHeaders;

  public MultiMap<String, String> getCustomParameters() {
    return customParameters;
  }

  public void setCustomParameters(MultiMap<String, String> customParameters) {
    this.customParameters = customParameters;
  }

  public MultiMap<String, String> getCustomHeaders() {
    return customHeaders;
  }

  public void setCustomHeaders(MultiMap<String, String> customHeaders) {
    this.customHeaders = customHeaders;
  }
}
