/*
 * Copyright (c) MuleSoft, Inc.  All rights reserved.  http://www.mulesoft.com
 * The software in this package is published under the terms of the CPAL v1.0
 * license, a copy of which has been included with this distribution in the
 * LICENSE.txt file.
 */
package org.mule.runtime.oauth.internal.config;

import org.mule.runtime.api.el.MuleExpressionLanguage;
import org.mule.runtime.api.lock.LockFactory;
import org.mule.runtime.api.scheduler.SchedulerService;
import org.mule.runtime.http.api.client.HttpClient;
import org.mule.runtime.oauth.api.listener.OAuthStateListener;
import org.mule.runtime.oauth.api.state.ResourceOwnerOAuthContext;

import java.nio.charset.Charset;
import java.util.List;
import java.util.Map;
import java.util.function.Function;

/**
 * A set of common attributes to all grant-types dancer.
 *
 * @since 1.0
 */
public abstract class OAuthDancerConfig {

  private String name;
  private AuthDancerCredentialConfig credentialConfig;
  private String tokenUrl;
  private Charset encoding;
  private String scopes;

  private TokenParserConfig tokenParserConfig;

  private Map<String, String> customParametersExtractorsExprs;
  private Function<String, String> resourceOwnerIdTransformer;
  private SchedulerService schedulerService;
  private LockFactory lockProvider;

  private Map<String, ResourceOwnerOAuthContext> tokensStore;
  private HttpClient httpClient;
  private MuleExpressionLanguage expressionEvaluator;
  private List<? extends OAuthStateListener> listeners;

  public String getName() {
    return name;
  }

  public void setName(String name) {
    this.name = name;
  }

  public AuthDancerCredentialConfig getCredentialConfig() {
    return credentialConfig;
  }

  public void setCredentialConfig(AuthDancerCredentialConfig credentialConfig) {
    this.credentialConfig = credentialConfig;
  }

  public String getTokenUrl() {
    return tokenUrl;
  }

  public void setTokenUrl(String tokenUrl) {
    this.tokenUrl = tokenUrl;
  }

  public Charset getEncoding() {
    return encoding;
  }

  public void setEncoding(Charset encoding) {
    this.encoding = encoding;
  }

  public String getScopes() {
    return scopes;
  }

  public void setScopes(String scopes) {
    this.scopes = scopes;
  }

  public TokenParserConfig getTokenParserConfig() {
    return tokenParserConfig;
  }

  public void setTokenParserConfig(TokenParserConfig tokenParserConfig) {
    this.tokenParserConfig = tokenParserConfig;
  }

  public Map<String, String> getCustomParametersExtractorsExprs() {
    return customParametersExtractorsExprs;
  }

  public void setCustomParametersExtractorsExprs(Map<String, String> customParametersExtractorsExprs) {
    this.customParametersExtractorsExprs = customParametersExtractorsExprs;
  }

  public Function<String, String> getResourceOwnerIdTransformer() {
    return resourceOwnerIdTransformer;
  }

  public void setResourceOwnerIdTransformer(Function<String, String> resourceOwnerIdTransformer) {
    this.resourceOwnerIdTransformer = resourceOwnerIdTransformer;
  }

  public SchedulerService getSchedulerService() {
    return schedulerService;
  }

  public void setSchedulerService(SchedulerService schedulerService) {
    this.schedulerService = schedulerService;
  }

  public LockFactory getLockProvider() {
    return lockProvider;
  }

  public void setLockProvider(LockFactory lockProvider) {
    this.lockProvider = lockProvider;
  }

  public Map<String, ResourceOwnerOAuthContext> getTokensStore() {
    return tokensStore;
  }

  public void setTokensStore(Map<String, ResourceOwnerOAuthContext> tokensStore) {
    this.tokensStore = tokensStore;
  }

  public HttpClient getHttpClient() {
    return httpClient;
  }

  public void setHttpClient(HttpClient httpClient) {
    this.httpClient = httpClient;
  }

  public MuleExpressionLanguage getExpressionEvaluator() {
    return expressionEvaluator;
  }

  public void setExpressionEvaluator(MuleExpressionLanguage expressionEvaluator) {
    this.expressionEvaluator = expressionEvaluator;
  }

  public List<? extends OAuthStateListener> getListeners() {
    return listeners;
  }

  public void setListeners(List<? extends OAuthStateListener> listeners) {
    this.listeners = listeners;
  }
}
