/*
 * Decompiled with CFR 0.152.
 */
package org.mule.runtime.test.oauth.internal;

import io.qameta.allure.Story;
import java.util.Arrays;
import java.util.Collection;
import org.junit.Test;
import org.junit.runner.RunWith;
import org.junit.runners.Parameterized;
import org.mockito.ArgumentMatchers;
import org.mockito.Mockito;
import org.mockito.verification.VerificationMode;
import org.mule.oauth.client.api.ClientCredentialsOAuthDancer;
import org.mule.oauth.client.api.builder.OAuthClientCredentialsDancerBuilder;
import org.mule.runtime.api.exception.MuleException;
import org.mule.runtime.api.tls.TlsContextFactory;
import org.mule.runtime.core.api.lifecycle.LifecycleUtils;
import org.mule.runtime.http.api.client.HttpClient;
import org.mule.runtime.http.api.client.HttpClientConfiguration;
import org.mule.runtime.http.api.client.HttpClientFactory;
import org.mule.runtime.http.api.client.proxy.ProxyConfig;
import org.mule.runtime.test.oauth.AbstractOAuthTestCase;

@RunWith(value=Parameterized.class)
@Story(value="Client credentials")
public class DancerHttpClientReuseTestCase
extends AbstractOAuthTestCase {
    private static final TlsContextFactory TLS_A = (TlsContextFactory)Mockito.mock(TlsContextFactory.class);
    private static final TlsContextFactory TLS_B = (TlsContextFactory)Mockito.mock(TlsContextFactory.class);
    private static final ProxyConfig PROXY_A = (ProxyConfig)Mockito.mock(ProxyConfig.class);
    private static final ProxyConfig PROXY_B = (ProxyConfig)Mockito.mock(ProxyConfig.class);
    private final String tokenUrlA;
    private final TlsContextFactory tlsA;
    private final ProxyConfig proxyA;
    private final String tokenUrlB;
    private final TlsContextFactory tlsB;
    private final ProxyConfig proxyB;
    private final VerificationMode httpclientStartVerificationModeB;
    private final VerificationMode httpclientStopVerificationModeB;
    private final VerificationMode httpclientStopVerificationModeA;

    @Parameterized.Parameters(name="{0}")
    public static Collection<Object[]> params() {
        return Arrays.asList({"same url, no tls, no proxy", "http://host/token", null, null, "http://host/token", null, null, Mockito.times((int)1), Mockito.never(), Mockito.times((int)1)}, {"different url, no tls, no proxy", "http://host/token1", null, null, "http://host/token2", null, null, Mockito.times((int)1), Mockito.never(), Mockito.times((int)1)}, {"tls / no tls", "http://host/token1", TLS_A, null, "http://host/token2", null, null, Mockito.times((int)2), Mockito.times((int)1), Mockito.times((int)2)}, {"proxy / no proxy", "http://host/token1", null, PROXY_A, "http://host/token2", null, null, Mockito.times((int)2), Mockito.times((int)1), Mockito.times((int)2)}, {"tls+proxy", "http://host/token1", TLS_A, PROXY_A, "http://host/token2", TLS_A, PROXY_A, Mockito.times((int)1), Mockito.never(), Mockito.times((int)1)}, {"tls+proxy / !tls+proxy", "http://host/token1", TLS_A, PROXY_A, "http://host/token2", null, PROXY_A, Mockito.times((int)2), Mockito.times((int)1), Mockito.times((int)2)}, {"tls+proxy / tls+!proxy", "http://host/token1", TLS_A, PROXY_A, "http://host/token2", TLS_A, null, Mockito.times((int)2), Mockito.times((int)1), Mockito.times((int)2)}, {"diff tls", "http://host/token1", TLS_A, null, "http://host/token2", TLS_B, null, Mockito.times((int)2), Mockito.times((int)1), Mockito.times((int)2)}, {"diff tls same proxy", "http://host/token1", TLS_A, PROXY_A, "http://host/token2", TLS_B, PROXY_A, Mockito.times((int)2), Mockito.times((int)1), Mockito.times((int)2)}, {"diff proxy", "http://host/token1", null, PROXY_A, "http://host/token2", null, PROXY_B, Mockito.times((int)2), Mockito.times((int)1), Mockito.times((int)2)}, {"diff proxy same tls", "http://host/token1", TLS_A, PROXY_A, "http://host/token2", TLS_A, PROXY_B, Mockito.times((int)2), Mockito.times((int)1), Mockito.times((int)2)}, {"tls+proxy / tls+proxy", "http://host/token1", TLS_A, PROXY_A, "http://host/token2", null, PROXY_A, Mockito.times((int)2), Mockito.times((int)1), Mockito.times((int)2)}, {"tls+proxy / tls+proxy", "http://host/token1", TLS_A, PROXY_A, "http://host/token2", TLS_A, null, Mockito.times((int)2), Mockito.times((int)1), Mockito.times((int)2)});
    }

    public DancerHttpClientReuseTestCase(String description, String tokenUrlA, TlsContextFactory tlsA, ProxyConfig proxyA, String tokenUrlB, TlsContextFactory tlsB, ProxyConfig proxyB, VerificationMode httpclientStartVerificationModeB, VerificationMode httpclientStopVerificationModeB, VerificationMode httpclientStopVerificationModeA) {
        this.tokenUrlA = tokenUrlA;
        this.tlsA = tlsA;
        this.proxyA = proxyA;
        this.tokenUrlB = tokenUrlB;
        this.tlsB = tlsB;
        this.proxyB = proxyB;
        this.httpclientStartVerificationModeB = httpclientStartVerificationModeB;
        this.httpclientStopVerificationModeB = httpclientStopVerificationModeB;
        this.httpclientStopVerificationModeA = httpclientStopVerificationModeA;
    }

    @Test
    public void httpClientShared() throws MuleException {
        OAuthClientCredentialsDancerBuilder builderA = this.baseClientCredentialsDancerBuilder();
        builderA.tokenUrl(this.tokenUrlA, this.tlsA, this.proxyA);
        OAuthClientCredentialsDancerBuilder builderB = this.baseClientCredentialsDancerBuilder();
        builderB.tokenUrl(this.tokenUrlB, this.tlsB, this.proxyB);
        ClientCredentialsOAuthDancer dancerA = (ClientCredentialsOAuthDancer)this.startDancer(builderA);
        ((HttpClient)Mockito.verify((Object)this.httpClient, (VerificationMode)Mockito.times((int)1))).start();
        ClientCredentialsOAuthDancer dancerB = (ClientCredentialsOAuthDancer)this.startDancer(builderB);
        ((HttpClient)Mockito.verify((Object)this.httpClient, (VerificationMode)this.httpclientStartVerificationModeB)).start();
        ((HttpClientFactory)Mockito.verify((Object)this.httpClientFactory, (VerificationMode)this.httpclientStartVerificationModeB)).create((HttpClientConfiguration)ArgumentMatchers.any());
        LifecycleUtils.stopIfNeeded((Object)dancerA);
        ((HttpClient)Mockito.verify((Object)this.httpClient, (VerificationMode)this.httpclientStopVerificationModeB)).stop();
        LifecycleUtils.stopIfNeeded((Object)dancerB);
        ((HttpClient)Mockito.verify((Object)this.httpClient, (VerificationMode)this.httpclientStopVerificationModeA)).stop();
    }

    @Test
    public void httpClientSharedStopDifferentOrder() throws MuleException {
        OAuthClientCredentialsDancerBuilder builderA = this.baseClientCredentialsDancerBuilder();
        builderA.tokenUrl(this.tokenUrlA, this.tlsA, this.proxyA);
        OAuthClientCredentialsDancerBuilder builderB = this.baseClientCredentialsDancerBuilder();
        builderB.tokenUrl(this.tokenUrlB, this.tlsB, this.proxyB);
        ClientCredentialsOAuthDancer dancerA = (ClientCredentialsOAuthDancer)this.startDancer(builderA);
        ((HttpClient)Mockito.verify((Object)this.httpClient, (VerificationMode)Mockito.times((int)1))).start();
        ClientCredentialsOAuthDancer dancerB = (ClientCredentialsOAuthDancer)this.startDancer(builderB);
        ((HttpClient)Mockito.verify((Object)this.httpClient, (VerificationMode)this.httpclientStartVerificationModeB)).start();
        ((HttpClientFactory)Mockito.verify((Object)this.httpClientFactory, (VerificationMode)this.httpclientStartVerificationModeB)).create((HttpClientConfiguration)ArgumentMatchers.any());
        LifecycleUtils.stopIfNeeded((Object)dancerB);
        ((HttpClient)Mockito.verify((Object)this.httpClient, (VerificationMode)this.httpclientStopVerificationModeB)).stop();
        LifecycleUtils.stopIfNeeded((Object)dancerA);
        ((HttpClient)Mockito.verify((Object)this.httpClient, (VerificationMode)this.httpclientStopVerificationModeA)).stop();
    }
}

