/*
 * Copyright 2023 Salesforce, Inc. All rights reserved.
 * The software in this package is published under the terms of the CPAL v1.0
 * license, a copy of which has been included with this distribution in the
 * LICENSE.txt file.
 */
package org.mule.oauth.client.internal.config;

import static org.mule.runtime.api.util.Preconditions.checkArgument;

import org.mule.oauth.client.api.AuthorizationCodeRequest;
import org.mule.oauth.client.api.builder.AuthorizationCodeDanceCallbackContext;
import org.mule.oauth.client.api.state.ResourceOwnerOAuthContext;
import org.mule.oauth.client.internal.DefaultAuthorizationCodeOAuthDancer;
import org.mule.runtime.api.util.MultiMap;
import org.mule.runtime.http.api.server.HttpServer;

import java.util.Collections;
import java.util.Map;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import java.util.function.Supplier;

/**
 * Set of attributes needed to create authorization-code dancer {@link DefaultAuthorizationCodeOAuthDancer}.
 *
 * @since 1.0
 */
public class DefaultAuthorizationCodeOAuthDancerConfig extends OAuthDancerConfig {

  private Optional<HttpServer> httpServer;

  private String localCallbackUrlPath;

  private String localAuthorizationUrlPath;
  private String localAuthorizationUrlResourceOwnerId;

  private String externalCallbackUrl;

  private String state;
  private String authorizationUrl;

  private Supplier<Map<String, String>> customParameters = Collections::emptyMap;
  private Supplier<Map<String, String>> customHeaders = Collections::emptyMap;
  private Supplier<Map<String, String>> customBodyParameters = Collections::emptyMap;

  private Function<AuthorizationCodeRequest, AuthorizationCodeDanceCallbackContext> beforeDanceCallback;
  private BiConsumer<AuthorizationCodeDanceCallbackContext, ResourceOwnerOAuthContext> afterDanceCallback;

  private MultiMap<String, String> additionalRefreshTokenRequestParameters = new MultiMap<>();
  private MultiMap<String, String> additionalRefreshTokenHeaders = new MultiMap<>();

  private boolean includeRedirectUriInRefreshTokenRequest;

  public Optional<HttpServer> getHttpServer() {
    return httpServer;
  }

  public void setHttpServer(Optional<HttpServer> httpServer) {
    this.httpServer = httpServer;
  }

  public String getLocalCallbackUrlPath() {
    return localCallbackUrlPath;
  }

  public void setLocalCallbackUrlPath(String localCallbackUrlPath) {
    this.localCallbackUrlPath = localCallbackUrlPath;
  }

  public String getLocalAuthorizationUrlPath() {
    return localAuthorizationUrlPath;
  }

  public void setLocalAuthorizationUrlPath(String localAuthorizationUrlPath) {
    this.localAuthorizationUrlPath = localAuthorizationUrlPath;
  }

  public String getLocalAuthorizationUrlResourceOwnerId() {
    return localAuthorizationUrlResourceOwnerId;
  }

  public void setLocalAuthorizationUrlResourceOwnerId(String localAuthorizationUrlResourceOwnerId) {
    this.localAuthorizationUrlResourceOwnerId = localAuthorizationUrlResourceOwnerId;
  }

  public String getExternalCallbackUrl() {
    return externalCallbackUrl;
  }

  public void setExternalCallbackUrl(String externalCallbackUrl) {
    this.externalCallbackUrl = externalCallbackUrl;
  }

  public String getState() {
    return state;
  }

  public void setState(String state) {
    this.state = state;
  }

  public String getAuthorizationUrl() {
    return authorizationUrl;
  }

  public void setAuthorizationUrl(String authorizationUrl) {
    this.authorizationUrl = authorizationUrl;
  }

  public Supplier<Map<String, String>> getCustomParameters() {
    return customParameters;
  }

  public void setCustomParameters(Supplier<Map<String, String>> customParameters) {
    checkArgument(customParameters != null, "customParameters cannot be null");
    this.customParameters = customParameters;
  }

  public Supplier<Map<String, String>> getCustomHeaders() {
    return customHeaders;
  }

  public Supplier<Map<String, String>> getCustomBodyParameters() {
    return customBodyParameters;
  }

  public void setCustomHeaders(Supplier<Map<String, String>> customHeaders) {
    checkArgument(customHeaders != null, "customHeaders cannot be null");
    this.customHeaders = customHeaders;
  }

  public void setCustomBodyParameters(Supplier<Map<String, String>> customBodyParameters) {
    checkArgument(customBodyParameters != null, "customBodyParameters cannot be null");
    this.customBodyParameters = customBodyParameters;
  }

  public Function<AuthorizationCodeRequest, AuthorizationCodeDanceCallbackContext> getBeforeDanceCallback() {
    return beforeDanceCallback;
  }

  public void setBeforeDanceCallback(Function<AuthorizationCodeRequest, AuthorizationCodeDanceCallbackContext> beforeDanceCallback) {
    this.beforeDanceCallback = beforeDanceCallback;
  }

  public BiConsumer<AuthorizationCodeDanceCallbackContext, ResourceOwnerOAuthContext> getAfterDanceCallback() {
    return afterDanceCallback;
  }

  public void setAfterDanceCallback(BiConsumer<AuthorizationCodeDanceCallbackContext, ResourceOwnerOAuthContext> afterDanceCallback) {
    this.afterDanceCallback = afterDanceCallback;
  }

  public MultiMap<String, String> getAdditionalRefreshTokenRequestParameters() {
    return additionalRefreshTokenRequestParameters;
  }

  public void setAdditionalRefreshTokenRequestParameters(MultiMap<String, String> additionalRefreshTokenParameters) {
    this.additionalRefreshTokenRequestParameters = additionalRefreshTokenParameters;
  }

  public MultiMap<String, String> getAdditionalRefreshTokenHeaders() {
    return additionalRefreshTokenHeaders;
  }

  public void setAdditionalRefreshTokenHeaders(MultiMap<String, String> additionalRefreshTokenHeaders) {
    this.additionalRefreshTokenHeaders = additionalRefreshTokenHeaders;
  }

  public boolean getIncludeRedirectUriInRefreshTokenRequest() {
    return includeRedirectUriInRefreshTokenRequest;
  }

  public void setIncludeRedirectUriInRefreshTokenRequest(boolean includeRedirectUriInRefreshTokenRequest) {
    this.includeRedirectUriInRefreshTokenRequest = includeRedirectUriInRefreshTokenRequest;
  }
}
