/*
 * Decompiled with CFR 0.152.
 */
package org.mule.runtime.test.oauth.authorizationcode;

import io.qameta.allure.Description;
import io.qameta.allure.Feature;
import io.qameta.allure.Issue;
import io.qameta.allure.Story;
import java.io.InputStream;
import java.net.URI;
import java.net.URLEncoder;
import java.nio.charset.Charset;
import java.nio.charset.StandardCharsets;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.concurrent.CountDownLatch;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.locks.ReentrantLock;
import java.util.function.Consumer;
import java.util.function.Supplier;
import org.apache.commons.io.IOUtils;
import org.hamcrest.Matcher;
import org.hamcrest.MatcherAssert;
import org.hamcrest.Matchers;
import org.hamcrest.text.IsEqualIgnoringCase;
import org.junit.After;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;
import org.junit.runner.RunWith;
import org.junit.runners.Parameterized;
import org.mockito.ArgumentCaptor;
import org.mockito.ArgumentMatchers;
import org.mockito.Mockito;
import org.mule.oauth.client.api.AuthorizationCodeOAuthDancer;
import org.mule.oauth.client.api.builder.ClientCredentialsLocation;
import org.mule.oauth.client.api.builder.OAuthAuthorizationCodeDancerBuilder;
import org.mule.oauth.client.api.listener.AuthorizationCodeListener;
import org.mule.oauth.client.api.state.ResourceOwnerOAuthContext;
import org.mule.oauth.client.api.state.ResourceOwnerOAuthContextWithRefreshState;
import org.mule.oauth.client.internal.builder.DefaultOAuthAuthorizationCodeDancerBuilder;
import org.mule.runtime.api.el.BindingContext;
import org.mule.runtime.api.el.MuleExpressionLanguage;
import org.mule.runtime.api.exception.MuleException;
import org.mule.runtime.api.metadata.DataType;
import org.mule.runtime.api.metadata.TypedValue;
import org.mule.runtime.api.scheduler.SchedulerService;
import org.mule.runtime.api.util.MultiMap;
import org.mule.runtime.api.util.concurrent.Latch;
import org.mule.runtime.core.api.lifecycle.LifecycleUtils;
import org.mule.runtime.http.api.HttpConstants;
import org.mule.runtime.http.api.client.HttpClient;
import org.mule.runtime.http.api.client.HttpRequestOptions;
import org.mule.runtime.http.api.domain.entity.HttpEntity;
import org.mule.runtime.http.api.domain.message.request.HttpRequest;
import org.mule.runtime.http.api.domain.message.response.HttpResponse;
import org.mule.runtime.http.api.domain.request.HttpRequestContext;
import org.mule.runtime.http.api.server.RequestHandler;
import org.mule.runtime.http.api.server.RequestHandlerManager;
import org.mule.runtime.http.api.server.async.HttpResponseReadyCallback;
import org.mule.runtime.http.api.server.async.ResponseStatusCallback;
import org.mule.runtime.test.oauth.AbstractOAuthTestCase;
import org.mule.runtime.test.oauth.state.CustomResourceOwnerOAuthContext;
import org.mule.tck.SimpleUnitTestSupportSchedulerService;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@RunWith(value=Parameterized.class)
@Story(value="Authorization Code")
public class AuthorizationCodeTokenTestCase
extends AbstractOAuthTestCase {
    private static final Logger LOGGER = LoggerFactory.getLogger(AuthorizationCodeTokenTestCase.class);
    private final ArgumentCaptor<RequestHandler> localCallbackCaptor = ArgumentCaptor.forClass(RequestHandler.class);
    private final ArgumentCaptor<RequestHandler> authCallbackCaptor = ArgumentCaptor.forClass(RequestHandler.class);
    private AuthorizationCodeOAuthDancer minimalDancer;
    private final Supplier<ResourceOwnerOAuthContext> contextSupplier;

    @Parameterized.Parameters
    public static Collection<Object[]> data() {
        return Arrays.asList({() -> {
            CustomResourceOwnerOAuthContext context = new CustomResourceOwnerOAuthContext(new ReentrantLock(), "default");
            context.setRefreshToken("refreshToken");
            return context;
        }}, {() -> {
            ResourceOwnerOAuthContextWithRefreshState context = new ResourceOwnerOAuthContextWithRefreshState("default");
            context.setRefreshToken("refreshToken");
            return context;
        }});
    }

    public AuthorizationCodeTokenTestCase(Supplier<ResourceOwnerOAuthContext> contextSupplier) {
        this.contextSupplier = contextSupplier;
    }

    @Before
    public void before() {
        Mockito.when((Object)this.httpServer.addRequestHandler((Collection)ArgumentMatchers.eq(Collections.singleton(HttpConstants.Method.GET.name())), (String)ArgumentMatchers.eq((Object)"/localCallback"), (RequestHandler)this.localCallbackCaptor.capture())).thenReturn((Object)((RequestHandlerManager)Mockito.mock(RequestHandlerManager.class)));
        Mockito.when((Object)this.httpServer.addRequestHandler((Collection)ArgumentMatchers.eq(Collections.singleton(HttpConstants.Method.GET.name())), (String)ArgumentMatchers.eq((Object)"/auth"), (RequestHandler)this.authCallbackCaptor.capture())).thenReturn((Object)((RequestHandlerManager)Mockito.mock(RequestHandlerManager.class)));
    }

    @After
    public void after() throws MuleException {
        if (this.minimalDancer != null) {
            LifecycleUtils.stopIfNeeded((Object)this.minimalDancer);
            LifecycleUtils.disposeIfNeeded((Object)this.minimalDancer, (Logger)LOGGER);
        }
    }

    private void assertAuthCodeCredentialsEncodedInHeader(boolean useDeprecatedMethod) throws Exception {
        OAuthAuthorizationCodeDancerBuilder builder = this.baseAuthCodeDancerbuilder();
        builder.tokenUrl("http://host/token");
        builder.authorizationUrl("http://host/auth");
        builder.localCallback(this.httpServer, "/localCallback");
        builder.localAuthorizationUrlPath("/auth");
        builder.clientCredentials("Aladdin", "open sesame");
        if (useDeprecatedMethod) {
            builder.encodeClientCredentialsInBody(false);
        } else {
            builder.withClientCredentialsIn(ClientCredentialsLocation.BASIC_AUTH_HEADER);
        }
        this.minimalDancer = (AuthorizationCodeOAuthDancer)this.startDancer(builder);
        ((RequestHandler)this.localCallbackCaptor.getValue()).handleRequest(this.buildLocalCallbackRequestContext(), (HttpResponseReadyCallback)Mockito.mock(HttpResponseReadyCallback.class));
        ArgumentCaptor requestCaptor = ArgumentCaptor.forClass(HttpRequest.class);
        ((HttpClient)Mockito.verify((Object)this.httpClient)).sendAsync((HttpRequest)requestCaptor.capture(), (HttpRequestOptions)ArgumentMatchers.any(HttpRequestOptions.class));
        MatcherAssert.assertThat((Object)((HttpRequest)requestCaptor.getValue()).getHeaderValue("Authorization"), (Matcher)Matchers.is((Object)"Basic QWxhZGRpbjpvcGVuIHNlc2FtZQ=="));
        MatcherAssert.assertThat((Object)((HttpRequest)requestCaptor.getValue()).getQueryParams(), (Matcher)Matchers.not((Matcher)Matchers.hasKey((Object)"client_id")));
        MatcherAssert.assertThat((Object)((HttpRequest)requestCaptor.getValue()).getQueryParams(), (Matcher)Matchers.not((Matcher)Matchers.hasKey((Object)"client_secret")));
        String requestBody = IOUtils.toString((InputStream)((HttpRequest)requestCaptor.getValue()).getEntity().getContent(), (Charset)StandardCharsets.UTF_8);
        MatcherAssert.assertThat((Object)requestBody, (Matcher)Matchers.containsString((String)"code=authCode"));
        MatcherAssert.assertThat((Object)requestBody, (Matcher)Matchers.containsString((String)"grant_type=authorization_code"));
        MatcherAssert.assertThat((Object)requestBody, (Matcher)Matchers.not((Matcher)Matchers.containsString((String)"client_secret=open+sesame")));
        MatcherAssert.assertThat((Object)requestBody, (Matcher)Matchers.not((Matcher)Matchers.containsString((String)"client_id=Aladdin")));
    }

    @Test
    public void requestWithNullAuthorizationCode() throws Exception {
        URI testUri = new URI("http://host/testUri");
        HttpResponse response = this.runCallback(requestMock -> {
            Mockito.when((Object)requestMock.getQueryParams()).thenReturn((Object)MultiMap.emptyMultiMap());
            Mockito.when((Object)requestMock.getUri()).thenReturn((Object)testUri);
        }, this.localCallbackCaptor);
        MatcherAssert.assertThat((Object)response.getStatusCode(), (Matcher)Matchers.is((Object)HttpConstants.HttpStatus.BAD_REQUEST.getStatusCode()));
        MatcherAssert.assertThat((Object)IOUtils.toString((InputStream)response.getEntity().getContent(), (Charset)StandardCharsets.UTF_8), (Matcher)Matchers.is((Object)("Failure retrieving access token.\n OAuth Server uri from callback: " + String.valueOf(testUri))));
    }

    @Test
    public void requestWithNullAuthorizationCodeAndRedirectOnComplete() throws Exception {
        String redirectUrl = "http://host:12/path";
        HttpResponse response = this.runCallback(requestMock -> {
            MultiMap queryParams = new MultiMap();
            queryParams.put((Object)"state", (Object)(":onCompleteRedirectTo=" + redirectUrl));
            Mockito.when((Object)requestMock.getQueryParams()).thenReturn((Object)queryParams);
        }, this.localCallbackCaptor);
        MatcherAssert.assertThat((Object)response.getStatusCode(), (Matcher)Matchers.is((Object)HttpConstants.HttpStatus.MOVED_TEMPORARILY.getStatusCode()));
        MatcherAssert.assertThat((Object)response.getHeaderValue("Location"), (Matcher)Matchers.is((Object)(redirectUrl + "?authorizationStatus=100")));
    }

    @Test
    public void exceptionHandlingRequest() throws Exception {
        String testError = "Testing error";
        HttpResponse response = this.runCallback(requestMock -> Mockito.when((Object)requestMock.getQueryParams()).then(invocationOnMock -> {
            throw new Exception(testError);
        }), this.localCallbackCaptor);
        MatcherAssert.assertThat((Object)response.getStatusCode(), (Matcher)Matchers.is((Object)HttpConstants.HttpStatus.INTERNAL_SERVER_ERROR.getStatusCode()));
        MatcherAssert.assertThat((Object)IOUtils.toString((InputStream)response.getEntity().getContent(), (Charset)StandardCharsets.UTF_8), (Matcher)Matchers.is((Object)testError));
    }

    @Test
    public void localAuthorizationRequest() throws Exception {
        this.runLocalAuthorizationCallback();
    }

    @Test
    public void localAuthorizationRequestWithResourceOwnerId() throws Exception {
        String testResourceOwnerId = "testResourceOwnerId";
        OAuthAuthorizationCodeDancerBuilder builder = this.baseAuthCodeDancerbuilder();
        builder.localAuthorizationUrlResourceOwnerId(testResourceOwnerId);
        HttpResponse response = this.runLocalAuthorizationCallback(builder);
        MatcherAssert.assertThat((Object)response.getHeaderValue("Location"), (Matcher)Matchers.containsString((String)(String.format("&%s=", "state") + URLEncoder.encode(":resourceOwnerId=" + testResourceOwnerId, StandardCharsets.UTF_8))));
    }

    @Test
    public void localAuthorizationRequestWithOriginalStateAndResourceOwnerId() throws Exception {
        String testOriginalState = "testOriginalState";
        String testResourceOwnerId = "testResourceOwnerId";
        OAuthAuthorizationCodeDancerBuilder builder = this.baseAuthCodeDancerbuilder();
        builder.state(testOriginalState);
        builder.localAuthorizationUrlResourceOwnerId(testResourceOwnerId);
        HttpResponse response = this.runLocalAuthorizationCallback(builder);
        MatcherAssert.assertThat((Object)response.getHeaderValue("Location"), (Matcher)Matchers.containsString((String)(String.format("&%s=%s", "state", testOriginalState) + URLEncoder.encode(":resourceOwnerId=" + testResourceOwnerId, StandardCharsets.UTF_8))));
    }

    @Test
    public void localAuthorizationRequestWithAndResourceOwnerIdStateAsExpression() throws Exception {
        MuleExpressionLanguage muleExpressionLanguage = (MuleExpressionLanguage)Mockito.mock(MuleExpressionLanguage.class);
        String testOriginalStateExpression = "#[attributes.queryParams.state]";
        String resolvedOriginalState = "resolvedOriginalState";
        ((MuleExpressionLanguage)Mockito.doReturn((Object)TypedValue.of((Object)resolvedOriginalState)).when((Object)muleExpressionLanguage)).evaluate((String)ArgumentMatchers.eq((Object)testOriginalStateExpression), (DataType)ArgumentMatchers.any(), (BindingContext)ArgumentMatchers.any());
        String testResourceOwnerIdExpression = "#[attributes.queryParams.resourceOwnerId]";
        String resolvedResourceOwnerId = "resolvedOriginalState";
        ((MuleExpressionLanguage)Mockito.doReturn((Object)TypedValue.of((Object)resolvedResourceOwnerId)).when((Object)muleExpressionLanguage)).evaluate((String)ArgumentMatchers.eq((Object)testResourceOwnerIdExpression), (DataType)ArgumentMatchers.any(), (BindingContext)ArgumentMatchers.any());
        ((MuleExpressionLanguage)Mockito.doReturn((Object)true).when((Object)muleExpressionLanguage)).isExpression((String)ArgumentMatchers.any());
        OAuthAuthorizationCodeDancerBuilder builder = this.baseAuthCodeDancerbuilder(muleExpressionLanguage);
        builder.state(testOriginalStateExpression);
        builder.localAuthorizationUrlResourceOwnerId(testResourceOwnerIdExpression);
        HttpResponse response = this.runLocalAuthorizationCallback(builder);
        MatcherAssert.assertThat((Object)response.getHeaderValue("Location"), (Matcher)Matchers.containsString((String)(String.format("&%s=%s", "state", resolvedOriginalState) + URLEncoder.encode(":resourceOwnerId=" + resolvedResourceOwnerId, StandardCharsets.UTF_8))));
    }

    @Test
    public void localAuthorizationRequestWithRedirect() throws Exception {
        String redirectUrl = "http://host:12/path";
        MultiMap queryParams = new MultiMap();
        queryParams.put((Object)"onCompleteRedirectTo", (Object)redirectUrl);
        HttpResponse response = this.runLocalAuthorizationCallback(this.baseAuthCodeDancerbuilder(), (MultiMap<String, String>)queryParams);
        MatcherAssert.assertThat((Object)response.getHeaderValue("Location"), (Matcher)Matchers.containsString((String)(String.format("&%s=", "state") + URLEncoder.encode(":onCompleteRedirectTo=" + redirectUrl, StandardCharsets.UTF_8))));
    }

    private void runLocalAuthorizationCallback() throws Exception {
        this.runLocalAuthorizationCallback(this.baseAuthCodeDancerbuilder());
    }

    private HttpResponse runLocalAuthorizationCallback(OAuthAuthorizationCodeDancerBuilder builder) throws Exception {
        return this.runLocalAuthorizationCallback(builder, (MultiMap<String, String>)MultiMap.emptyMultiMap());
    }

    private HttpResponse runLocalAuthorizationCallback(OAuthAuthorizationCodeDancerBuilder builder, MultiMap<String, String> queryParams) throws Exception {
        String testBody = "Testing body";
        HttpResponse response = this.runCallback(builder, requestMock -> {
            HttpEntity entity = (HttpEntity)Mockito.mock(HttpEntity.class);
            Mockito.when((Object)entity.getContent()).thenReturn((Object)IOUtils.toInputStream((String)testBody, (Charset)StandardCharsets.UTF_8));
            Mockito.when((Object)requestMock.getEntity()).thenReturn((Object)entity);
            Mockito.when((Object)requestMock.getHeaders()).thenReturn((Object)MultiMap.emptyMultiMap());
            Mockito.when((Object)requestMock.getQueryParams()).thenReturn((Object)queryParams);
        }, this.authCallbackCaptor);
        MatcherAssert.assertThat((Object)response.getStatusCode(), (Matcher)Matchers.is((Object)HttpConstants.HttpStatus.MOVED_TEMPORARILY.getStatusCode()));
        MatcherAssert.assertThat((Object)IOUtils.toString((InputStream)response.getEntity().getContent(), (Charset)StandardCharsets.UTF_8), (Matcher)Matchers.is((Object)testBody));
        return response;
    }

    private HttpResponse runCallback(Consumer<HttpRequest> requestMockConfigurer, ArgumentCaptor<RequestHandler> requestHandlerCaptor) throws Exception {
        return this.runCallback(this.baseAuthCodeDancerbuilder(), requestMockConfigurer, requestHandlerCaptor);
    }

    private HttpResponse runCallback(OAuthAuthorizationCodeDancerBuilder builder, Consumer<HttpRequest> requestMockConfigurer, ArgumentCaptor<RequestHandler> requestHandlerCaptor) throws Exception {
        builder.tokenUrl("http://host/token");
        builder.authorizationUrl("http://host/auth");
        builder.localCallback(this.httpServer, "/localCallback");
        builder.localAuthorizationUrlPath("/auth");
        builder.externalCallbackUrl("http://host/externalCallback");
        builder.withClientCredentialsIn(ClientCredentialsLocation.BASIC_AUTH_HEADER);
        this.minimalDancer = (AuthorizationCodeOAuthDancer)this.startDancer(builder);
        HttpRequest request = (HttpRequest)Mockito.mock(HttpRequest.class);
        requestMockConfigurer.accept(request);
        HttpRequestContext requestContext = (HttpRequestContext)Mockito.mock(HttpRequestContext.class);
        Mockito.when((Object)requestContext.getRequest()).thenReturn((Object)request);
        HttpResponseReadyCallback responseCallback = (HttpResponseReadyCallback)Mockito.mock(HttpResponseReadyCallback.class);
        ((RequestHandler)requestHandlerCaptor.getValue()).handleRequest(requestContext, responseCallback);
        ArgumentCaptor responseCaptor = ArgumentCaptor.forClass(HttpResponse.class);
        ArgumentCaptor responseStatusCaptor = ArgumentCaptor.forClass(ResponseStatusCallback.class);
        ((HttpResponseReadyCallback)Mockito.verify((Object)responseCallback)).responseReady((HttpResponse)responseCaptor.capture(), (ResponseStatusCallback)responseStatusCaptor.capture());
        ((ResponseStatusCallback)responseStatusCaptor.getValue()).responseSendFailure((Throwable)new RuntimeException());
        ((ResponseStatusCallback)responseStatusCaptor.getValue()).responseSendSuccessfully();
        return (HttpResponse)responseCaptor.getValue();
    }

    @Test
    public void authCodeCredentialsEncodedInHeader() throws Exception {
        this.assertAuthCodeCredentialsEncodedInHeader(false);
    }

    @Test
    public void authCodeCredentialsEncodedInHeaderCompatibility() throws Exception {
        this.assertAuthCodeCredentialsEncodedInHeader(true);
    }

    @Test
    @Issue(value="MULE-20019")
    @Description(value="Tests the listeners added without an identifying resource owner are correctly called.")
    public void authCodeListenersWithNoResourceOwnerCalled() throws Exception {
        OAuthAuthorizationCodeDancerBuilder builder = this.baseAuthCodeDancerbuilder();
        builder.tokenUrl("http://host/token");
        builder.authorizationUrl("http://host/auth");
        builder.localCallback(this.httpServer, "/localCallback");
        builder.localAuthorizationUrlPath("/auth");
        builder.clientCredentials("Aladdin", "open sesame");
        this.minimalDancer = (AuthorizationCodeOAuthDancer)this.startDancer(builder);
        final Latch onAuthorizationCompletedLatch = new Latch();
        final Latch onTokenRefreshedLatch = new Latch();
        final Latch onTokenInvalidatedLatch = new Latch();
        this.minimalDancer.addListener(new AuthorizationCodeListener(){

            public void onAuthorizationCompleted(ResourceOwnerOAuthContext context) {
                onAuthorizationCompletedLatch.release();
            }

            public void onTokenRefreshed(ResourceOwnerOAuthContext context) {
                onTokenRefreshedLatch.release();
            }

            public void onTokenInvalidated() {
                onTokenInvalidatedLatch.release();
            }
        });
        ((RequestHandler)this.localCallbackCaptor.getValue()).handleRequest(this.buildLocalCallbackRequestContext(), (HttpResponseReadyCallback)Mockito.mock(HttpResponseReadyCallback.class));
        Assert.assertTrue((boolean)onAuthorizationCompletedLatch.await(5000L, TimeUnit.MILLISECONDS));
        this.minimalDancer.refreshToken(null);
        Assert.assertTrue((boolean)onTokenRefreshedLatch.await(5000L, TimeUnit.MILLISECONDS));
        this.minimalDancer.invalidateContext(null);
        Assert.assertTrue((boolean)onTokenInvalidatedLatch.await(5000L, TimeUnit.MILLISECONDS));
    }

    @Test
    @Issue(value="MULE-20019")
    @Description(value="Tests the listeners added with an identifying resource owner are correctly called.")
    public void authCodeListenersWithResourceOwnerCalled() throws Exception {
        OAuthAuthorizationCodeDancerBuilder builder = this.baseAuthCodeDancerbuilder();
        builder.tokenUrl("http://host/token");
        builder.authorizationUrl("http://host/auth");
        builder.localCallback(this.httpServer, "/localCallback");
        builder.localAuthorizationUrlPath("/auth");
        builder.clientCredentials("Aladdin", "open sesame");
        this.minimalDancer = (AuthorizationCodeOAuthDancer)this.startDancer(builder);
        final CountDownLatch onAuthorizationCompletedLatch = new CountDownLatch(2);
        final CountDownLatch onTokenRefreshedLatch = new CountDownLatch(2);
        final CountDownLatch onTokenInvalidatedLatch = new CountDownLatch(2);
        this.minimalDancer.addListener("default", new AuthorizationCodeListener(){

            public void onAuthorizationCompleted(ResourceOwnerOAuthContext context) {
                onAuthorizationCompletedLatch.countDown();
            }

            public void onTokenRefreshed(ResourceOwnerOAuthContext context) {
                onTokenRefreshedLatch.countDown();
            }

            public void onTokenInvalidated() {
                onTokenInvalidatedLatch.countDown();
            }
        });
        this.minimalDancer.addListener("default", new AuthorizationCodeListener(){

            public void onAuthorizationCompleted(ResourceOwnerOAuthContext context) {
                onAuthorizationCompletedLatch.countDown();
            }

            public void onTokenRefreshed(ResourceOwnerOAuthContext context) {
                onTokenRefreshedLatch.countDown();
            }

            public void onTokenInvalidated() {
                onTokenInvalidatedLatch.countDown();
            }
        });
        ((RequestHandler)this.localCallbackCaptor.getValue()).handleRequest(this.buildLocalCallbackRequestContext(), (HttpResponseReadyCallback)Mockito.mock(HttpResponseReadyCallback.class));
        Assert.assertTrue((boolean)onAuthorizationCompletedLatch.await(5000L, TimeUnit.MILLISECONDS));
        this.minimalDancer.refreshToken("default");
        Assert.assertTrue((boolean)onTokenRefreshedLatch.await(5000L, TimeUnit.MILLISECONDS));
        this.minimalDancer.invalidateContext("default");
        Assert.assertTrue((boolean)onTokenInvalidatedLatch.await(5000L, TimeUnit.MILLISECONDS));
    }

    @Test
    public void authCodeCredentialsInBodyByDefault() throws Exception {
        OAuthAuthorizationCodeDancerBuilder builder = this.baseAuthCodeDancerbuilder();
        builder.tokenUrl("http://host/token");
        builder.authorizationUrl("http://host/auth");
        builder.localCallback(this.httpServer, "/localCallback");
        builder.localAuthorizationUrlPath("/auth");
        builder.clientCredentials("Aladdin", "open sesame");
        this.minimalDancer = (AuthorizationCodeOAuthDancer)this.startDancer(builder);
        ((RequestHandler)this.localCallbackCaptor.getValue()).handleRequest(this.buildLocalCallbackRequestContext(), (HttpResponseReadyCallback)Mockito.mock(HttpResponseReadyCallback.class));
        ArgumentCaptor requestCaptor = ArgumentCaptor.forClass(HttpRequest.class);
        ((HttpClient)Mockito.verify((Object)this.httpClient)).sendAsync((HttpRequest)requestCaptor.capture(), (HttpRequestOptions)ArgumentMatchers.any(HttpRequestOptions.class));
        MatcherAssert.assertThat((Object)((HttpRequest)requestCaptor.getValue()).getHeaderNames(), (Matcher)Matchers.not((Matcher)Matchers.hasItem((Matcher)IsEqualIgnoringCase.equalToIgnoringCase((String)"Authorization"))));
        MatcherAssert.assertThat((Object)((HttpRequest)requestCaptor.getValue()).getQueryParams(), (Matcher)Matchers.not((Matcher)Matchers.hasKey((Object)"client_id")));
        MatcherAssert.assertThat((Object)((HttpRequest)requestCaptor.getValue()).getQueryParams(), (Matcher)Matchers.not((Matcher)Matchers.hasKey((Object)"client_secret")));
        String requestBody = IOUtils.toString((InputStream)((HttpRequest)requestCaptor.getValue()).getEntity().getContent(), (Charset)StandardCharsets.UTF_8);
        MatcherAssert.assertThat((Object)requestBody, (Matcher)Matchers.containsString((String)"grant_type=authorization_code"));
        MatcherAssert.assertThat((Object)requestBody, (Matcher)Matchers.containsString((String)"client_secret=open+sesame"));
        MatcherAssert.assertThat((Object)requestBody, (Matcher)Matchers.containsString((String)"client_id=Aladdin"));
        MatcherAssert.assertThat((Object)requestBody, (Matcher)Matchers.containsString((String)"code=authCode"));
    }

    private void assertAuthCodeCredentialsInBody(boolean useDeprecatedMethod) throws Exception {
        OAuthAuthorizationCodeDancerBuilder builder = this.baseAuthCodeDancerbuilder();
        builder.tokenUrl("http://host/token");
        builder.authorizationUrl("http://host/auth");
        builder.localCallback(this.httpServer, "/localCallback");
        builder.localAuthorizationUrlPath("/auth");
        builder.clientCredentials("Aladdin", "open sesame");
        if (useDeprecatedMethod) {
            builder.encodeClientCredentialsInBody(true);
        } else {
            builder.withClientCredentialsIn(ClientCredentialsLocation.BODY);
        }
        this.minimalDancer = (AuthorizationCodeOAuthDancer)this.startDancer(builder);
        ((RequestHandler)this.localCallbackCaptor.getValue()).handleRequest(this.buildLocalCallbackRequestContext(), (HttpResponseReadyCallback)Mockito.mock(HttpResponseReadyCallback.class));
        ArgumentCaptor requestCaptor = ArgumentCaptor.forClass(HttpRequest.class);
        ((HttpClient)Mockito.verify((Object)this.httpClient)).sendAsync((HttpRequest)requestCaptor.capture(), (HttpRequestOptions)ArgumentMatchers.any(HttpRequestOptions.class));
        MatcherAssert.assertThat((Object)((HttpRequest)requestCaptor.getValue()).getHeaderNames(), (Matcher)Matchers.not((Matcher)Matchers.hasItem((Matcher)IsEqualIgnoringCase.equalToIgnoringCase((String)"Authorization"))));
        MatcherAssert.assertThat((Object)((HttpRequest)requestCaptor.getValue()).getQueryParams(), (Matcher)Matchers.not((Matcher)Matchers.hasKey((Object)"client_id")));
        MatcherAssert.assertThat((Object)((HttpRequest)requestCaptor.getValue()).getQueryParams(), (Matcher)Matchers.not((Matcher)Matchers.hasKey((Object)"client_secret")));
        String requestBody = IOUtils.toString((InputStream)((HttpRequest)requestCaptor.getValue()).getEntity().getContent(), (Charset)StandardCharsets.UTF_8);
        MatcherAssert.assertThat((Object)requestBody, (Matcher)Matchers.containsString((String)"grant_type=authorization_code"));
        MatcherAssert.assertThat((Object)requestBody, (Matcher)Matchers.containsString((String)"client_secret=open+sesame"));
        MatcherAssert.assertThat((Object)requestBody, (Matcher)Matchers.containsString((String)"client_id=Aladdin"));
        MatcherAssert.assertThat((Object)requestBody, (Matcher)Matchers.containsString((String)"code=authCode"));
    }

    @Test
    public void authCodeCredentialsInBodyCompatibility() throws Exception {
        this.assertAuthCodeCredentialsInBody(true);
    }

    @Test
    public void authCodeCredentialsInBody() throws Exception {
        this.assertAuthCodeCredentialsInBody(false);
    }

    protected HttpRequestContext buildLocalCallbackRequestContext() {
        HttpRequest request = (HttpRequest)Mockito.mock(HttpRequest.class);
        MultiMap queryParams = new MultiMap();
        queryParams.put((Object)"code", (Object)"authCode");
        Mockito.when((Object)request.getQueryParams()).thenReturn((Object)queryParams);
        HttpRequestContext requestContext = (HttpRequestContext)Mockito.mock(HttpRequestContext.class);
        Mockito.when((Object)requestContext.getRequest()).thenReturn((Object)request);
        return requestContext;
    }

    private void assertAuthCodeCredentialsEncodedInHeaderRefresh(boolean useDeprecatedMethod) throws Exception {
        OAuthAuthorizationCodeDancerBuilder builder = this.baseAuthCodeDancerbuilder();
        builder.tokenUrl("http://host/token");
        builder.authorizationUrl("http://host/auth");
        builder.clientCredentials("Aladdin", "open sesame");
        if (useDeprecatedMethod) {
            builder.encodeClientCredentialsInBody(false);
        } else {
            builder.withClientCredentialsIn(ClientCredentialsLocation.BASIC_AUTH_HEADER);
        }
        this.minimalDancer = (AuthorizationCodeOAuthDancer)this.startDancer(builder);
        this.minimalDancer.refreshToken(null);
        ArgumentCaptor requestCaptor = ArgumentCaptor.forClass(HttpRequest.class);
        ((HttpClient)Mockito.verify((Object)this.httpClient)).sendAsync((HttpRequest)requestCaptor.capture(), (HttpRequestOptions)ArgumentMatchers.any(HttpRequestOptions.class));
        MatcherAssert.assertThat((Object)((HttpRequest)requestCaptor.getValue()).getHeaderValue("Authorization"), (Matcher)Matchers.is((Object)"Basic QWxhZGRpbjpvcGVuIHNlc2FtZQ=="));
        MatcherAssert.assertThat((Object)((HttpRequest)requestCaptor.getValue()).getQueryParams(), (Matcher)Matchers.not((Matcher)Matchers.hasKey((Object)"client_id")));
        MatcherAssert.assertThat((Object)((HttpRequest)requestCaptor.getValue()).getQueryParams(), (Matcher)Matchers.not((Matcher)Matchers.hasKey((Object)"client_secret")));
        String requestBody = IOUtils.toString((InputStream)((HttpRequest)requestCaptor.getValue()).getEntity().getContent(), (Charset)StandardCharsets.UTF_8);
        MatcherAssert.assertThat((Object)requestBody, (Matcher)Matchers.containsString((String)"grant_type=refresh_token"));
        MatcherAssert.assertThat((Object)requestBody, (Matcher)Matchers.not((Matcher)Matchers.containsString((String)"client_secret=open+sesame")));
        MatcherAssert.assertThat((Object)requestBody, (Matcher)Matchers.not((Matcher)Matchers.containsString((String)"client_id=Aladdin")));
    }

    @Test
    public void authCodeCredentialsEncodedInHeaderRefreshCompatibility() throws Exception {
        this.assertAuthCodeCredentialsEncodedInHeaderRefresh(true);
    }

    @Test
    public void authCodeCredentialsEncodedInHeaderRefresh() throws Exception {
        this.assertAuthCodeCredentialsEncodedInHeaderRefresh(false);
    }

    @Test
    public void authCodeCredentialsInBodyRefreshByDefault() throws Exception {
        OAuthAuthorizationCodeDancerBuilder builder = this.baseAuthCodeDancerbuilder();
        builder.tokenUrl("http://host/token");
        builder.authorizationUrl("http://host/auth");
        builder.clientCredentials("Aladdin", "open sesame");
        this.minimalDancer = (AuthorizationCodeOAuthDancer)this.startDancer(builder);
        this.minimalDancer.refreshToken(null);
        ArgumentCaptor requestCaptor = ArgumentCaptor.forClass(HttpRequest.class);
        ((HttpClient)Mockito.verify((Object)this.httpClient)).sendAsync((HttpRequest)requestCaptor.capture(), (HttpRequestOptions)ArgumentMatchers.any(HttpRequestOptions.class));
        MatcherAssert.assertThat((Object)((HttpRequest)requestCaptor.getValue()).getHeaderNames(), (Matcher)Matchers.not((Matcher)Matchers.hasItem((Matcher)IsEqualIgnoringCase.equalToIgnoringCase((String)"Authorization"))));
        MatcherAssert.assertThat((Object)((HttpRequest)requestCaptor.getValue()).getQueryParams(), (Matcher)Matchers.not((Matcher)Matchers.hasKey((Object)"client_id")));
        MatcherAssert.assertThat((Object)((HttpRequest)requestCaptor.getValue()).getQueryParams(), (Matcher)Matchers.not((Matcher)Matchers.hasKey((Object)"client_secret")));
        String requestBody = IOUtils.toString((InputStream)((HttpRequest)requestCaptor.getValue()).getEntity().getContent(), (Charset)StandardCharsets.UTF_8);
        MatcherAssert.assertThat((Object)requestBody, (Matcher)Matchers.containsString((String)"grant_type=refresh_token"));
        MatcherAssert.assertThat((Object)requestBody, (Matcher)Matchers.containsString((String)"client_secret=open+sesame"));
        MatcherAssert.assertThat((Object)requestBody, (Matcher)Matchers.containsString((String)"client_id=Aladdin"));
    }

    private void assertAuthCodeCredentialsInBodyRefresh(boolean useDeprecatedMethod) throws Exception {
        OAuthAuthorizationCodeDancerBuilder builder = this.baseAuthCodeDancerbuilder();
        builder.tokenUrl("http://host/token");
        builder.authorizationUrl("http://host/auth");
        builder.clientCredentials("Aladdin", "open sesame");
        if (useDeprecatedMethod) {
            builder.encodeClientCredentialsInBody(true);
        } else {
            builder.withClientCredentialsIn(ClientCredentialsLocation.BODY);
        }
        this.minimalDancer = (AuthorizationCodeOAuthDancer)this.startDancer(builder);
        this.minimalDancer.refreshToken(null);
        ArgumentCaptor requestCaptor = ArgumentCaptor.forClass(HttpRequest.class);
        ((HttpClient)Mockito.verify((Object)this.httpClient)).sendAsync((HttpRequest)requestCaptor.capture(), (HttpRequestOptions)ArgumentMatchers.any(HttpRequestOptions.class));
        MatcherAssert.assertThat((Object)((HttpRequest)requestCaptor.getValue()).getHeaderNames(), (Matcher)Matchers.not((Matcher)Matchers.hasItem((Matcher)IsEqualIgnoringCase.equalToIgnoringCase((String)"Authorization"))));
        MatcherAssert.assertThat((Object)((HttpRequest)requestCaptor.getValue()).getQueryParams(), (Matcher)Matchers.not((Matcher)Matchers.hasKey((Object)"client_id")));
        MatcherAssert.assertThat((Object)((HttpRequest)requestCaptor.getValue()).getQueryParams(), (Matcher)Matchers.not((Matcher)Matchers.hasKey((Object)"client_secret")));
        String requestBody = IOUtils.toString((InputStream)((HttpRequest)requestCaptor.getValue()).getEntity().getContent(), (Charset)StandardCharsets.UTF_8);
        MatcherAssert.assertThat((Object)requestBody, (Matcher)Matchers.containsString((String)"grant_type=refresh_token"));
        MatcherAssert.assertThat((Object)requestBody, (Matcher)Matchers.containsString((String)"client_secret=open+sesame"));
        MatcherAssert.assertThat((Object)requestBody, (Matcher)Matchers.containsString((String)"client_id=Aladdin"));
    }

    @Test
    public void authCodeCredentialsInBodyRefreshCompatibility() throws Exception {
        this.assertAuthCodeCredentialsInBodyRefresh(true);
    }

    @Test
    public void authCodeCredentialsInBodyRefresh() throws Exception {
        this.assertAuthCodeCredentialsInBodyRefresh(false);
    }

    @Test
    public void authCodeRefreshTokenWithQueryParamsIncludingRedirectUriParameter() throws Exception {
        OAuthAuthorizationCodeDancerBuilder builder = this.baseAuthCodeDancerbuilder();
        builder.tokenUrl("http://host/token");
        builder.authorizationUrl("http://host/auth");
        builder.clientCredentials("Aladdin", "openSesame");
        builder.externalCallbackUrl("http://localhost:8081/callback");
        this.minimalDancer = (AuthorizationCodeOAuthDancer)this.startDancer(builder);
        this.minimalDancer.refreshToken(null, true);
        ArgumentCaptor requestCaptor = ArgumentCaptor.forClass(HttpRequest.class);
        ((HttpClient)Mockito.verify((Object)this.httpClient)).sendAsync((HttpRequest)requestCaptor.capture(), (HttpRequestOptions)ArgumentMatchers.any(HttpRequestOptions.class));
        MatcherAssert.assertThat((Object)((String)((HttpRequest)requestCaptor.getValue()).getQueryParams().get((Object)"client_id")), (Matcher)Matchers.is((Object)"Aladdin"));
        MatcherAssert.assertThat((Object)((String)((HttpRequest)requestCaptor.getValue()).getQueryParams().get((Object)"client_secret")), (Matcher)Matchers.is((Object)"openSesame"));
        MatcherAssert.assertThat((Object)((String)((HttpRequest)requestCaptor.getValue()).getQueryParams().get((Object)"grant_type")), (Matcher)Matchers.is((Object)"refresh_token"));
        MatcherAssert.assertThat((Object)((String)((HttpRequest)requestCaptor.getValue()).getQueryParams().get((Object)"refresh_token")), (Matcher)Matchers.is((Object)"refreshToken"));
        MatcherAssert.assertThat((Object)((String)((HttpRequest)requestCaptor.getValue()).getQueryParams().get((Object)"redirect_uri")), (Matcher)Matchers.is((Object)"http://localhost:8081/callback"));
        String requestBody = IOUtils.toString((InputStream)((HttpRequest)requestCaptor.getValue()).getEntity().getContent(), (Charset)StandardCharsets.UTF_8);
        MatcherAssert.assertThat((Object)requestBody, (Matcher)Matchers.not((Matcher)Matchers.containsString((String)"grant_type=refresh_token")));
        MatcherAssert.assertThat((Object)requestBody, (Matcher)Matchers.not((Matcher)Matchers.containsString((String)"refresh_token=")));
        MatcherAssert.assertThat((Object)requestBody, (Matcher)Matchers.not((Matcher)Matchers.containsString((String)"client_secret=openSesame")));
        MatcherAssert.assertThat((Object)requestBody, (Matcher)Matchers.not((Matcher)Matchers.containsString((String)"client_id=Aladdin")));
    }

    @Test
    public void authCodeRefreshTokenWithQueryParamsAndAdditionalParameters() throws Exception {
        OAuthAuthorizationCodeDancerBuilder builder = this.baseAuthCodeDancerbuilder();
        builder.tokenUrl("http://host/token");
        builder.authorizationUrl("http://host/auth");
        builder.clientCredentials("Aladdin", "openSesame");
        builder.externalCallbackUrl("http://localhost:8081/callback");
        MultiMap additionalRefreshTokenParameters = new MultiMap();
        additionalRefreshTokenParameters.put((Object)"additional_parameter", (Object)"additionalParam");
        builder.addAdditionalRefreshTokenRequestParameters(additionalRefreshTokenParameters);
        this.minimalDancer = (AuthorizationCodeOAuthDancer)this.startDancer(builder);
        this.minimalDancer.refreshToken(null, true);
        ArgumentCaptor requestCaptor = ArgumentCaptor.forClass(HttpRequest.class);
        ((HttpClient)Mockito.verify((Object)this.httpClient)).sendAsync((HttpRequest)requestCaptor.capture(), (HttpRequestOptions)ArgumentMatchers.any(HttpRequestOptions.class));
        MatcherAssert.assertThat((Object)((String)((HttpRequest)requestCaptor.getValue()).getQueryParams().get((Object)"client_id")), (Matcher)Matchers.is((Object)"Aladdin"));
        MatcherAssert.assertThat((Object)((String)((HttpRequest)requestCaptor.getValue()).getQueryParams().get((Object)"client_secret")), (Matcher)Matchers.is((Object)"openSesame"));
        MatcherAssert.assertThat((Object)((String)((HttpRequest)requestCaptor.getValue()).getQueryParams().get((Object)"grant_type")), (Matcher)Matchers.is((Object)"refresh_token"));
        MatcherAssert.assertThat((Object)((String)((HttpRequest)requestCaptor.getValue()).getQueryParams().get((Object)"refresh_token")), (Matcher)Matchers.is((Object)"refreshToken"));
        MatcherAssert.assertThat((Object)((String)((HttpRequest)requestCaptor.getValue()).getQueryParams().get((Object)"additional_parameter")), (Matcher)Matchers.is((Object)"additionalParam"));
        MatcherAssert.assertThat((Object)((String)((HttpRequest)requestCaptor.getValue()).getQueryParams().get((Object)"redirect_uri")), (Matcher)Matchers.is((Object)"http://localhost:8081/callback"));
        String requestBody = IOUtils.toString((InputStream)((HttpRequest)requestCaptor.getValue()).getEntity().getContent(), (Charset)StandardCharsets.UTF_8);
        MatcherAssert.assertThat((Object)requestBody, (Matcher)Matchers.not((Matcher)Matchers.containsString((String)"grant_type=refresh_token")));
        MatcherAssert.assertThat((Object)requestBody, (Matcher)Matchers.not((Matcher)Matchers.containsString((String)"refresh_token=")));
        MatcherAssert.assertThat((Object)requestBody, (Matcher)Matchers.not((Matcher)Matchers.containsString((String)"client_secret=openSesame")));
        MatcherAssert.assertThat((Object)requestBody, (Matcher)Matchers.not((Matcher)Matchers.containsString((String)"client_id=Aladdin")));
    }

    @Test
    public void authCodeRefreshTokenWithQueryParamsAndAdditionalHeaders() throws Exception {
        OAuthAuthorizationCodeDancerBuilder builder = this.baseAuthCodeDancerbuilder();
        builder.tokenUrl("http://host/token");
        builder.authorizationUrl("http://host/auth");
        builder.clientCredentials("Aladdin", "openSesame");
        builder.externalCallbackUrl("http://localhost:8081/callback");
        MultiMap additionalRefreshTokenHeaders = new MultiMap();
        additionalRefreshTokenHeaders.put((Object)"additional_header", (Object)"header");
        builder.addAdditionalRefreshTokenRequestHeaders(additionalRefreshTokenHeaders);
        this.minimalDancer = (AuthorizationCodeOAuthDancer)this.startDancer(builder);
        this.minimalDancer.refreshToken(null, true);
        ArgumentCaptor requestCaptor = ArgumentCaptor.forClass(HttpRequest.class);
        ((HttpClient)Mockito.verify((Object)this.httpClient)).sendAsync((HttpRequest)requestCaptor.capture(), (HttpRequestOptions)ArgumentMatchers.any(HttpRequestOptions.class));
        MatcherAssert.assertThat((Object)((String)((HttpRequest)requestCaptor.getValue()).getQueryParams().get((Object)"client_id")), (Matcher)Matchers.is((Object)"Aladdin"));
        MatcherAssert.assertThat((Object)((String)((HttpRequest)requestCaptor.getValue()).getQueryParams().get((Object)"client_secret")), (Matcher)Matchers.is((Object)"openSesame"));
        MatcherAssert.assertThat((Object)((String)((HttpRequest)requestCaptor.getValue()).getQueryParams().get((Object)"grant_type")), (Matcher)Matchers.is((Object)"refresh_token"));
        MatcherAssert.assertThat((Object)((String)((HttpRequest)requestCaptor.getValue()).getQueryParams().get((Object)"refresh_token")), (Matcher)Matchers.is((Object)"refreshToken"));
        MatcherAssert.assertThat((Object)((String)((HttpRequest)requestCaptor.getValue()).getQueryParams().get((Object)"redirect_uri")), (Matcher)Matchers.is((Object)"http://localhost:8081/callback"));
        MatcherAssert.assertThat((Object)((HttpRequest)requestCaptor.getValue()).getHeaderValue("additional_header"), (Matcher)Matchers.is((Object)"header"));
        String requestBody = IOUtils.toString((InputStream)((HttpRequest)requestCaptor.getValue()).getEntity().getContent(), (Charset)StandardCharsets.UTF_8);
        MatcherAssert.assertThat((Object)requestBody, (Matcher)Matchers.not((Matcher)Matchers.containsString((String)"grant_type=refresh_token")));
        MatcherAssert.assertThat((Object)requestBody, (Matcher)Matchers.not((Matcher)Matchers.containsString((String)"refresh_token=")));
        MatcherAssert.assertThat((Object)requestBody, (Matcher)Matchers.not((Matcher)Matchers.containsString((String)"client_secret=openSesame")));
        MatcherAssert.assertThat((Object)requestBody, (Matcher)Matchers.not((Matcher)Matchers.containsString((String)"client_id=Aladdin")));
    }

    @Test
    @Feature(value="Custom parameters in Body")
    public void authCodeRefreshTokenWithCustomBodyParam() throws Exception {
        OAuthAuthorizationCodeDancerBuilder builder = this.baseAuthCodeDancerbuilder();
        builder.tokenUrl("http://host/token");
        builder.authorizationUrl("http://host/auth");
        builder.localCallback(this.httpServer, "/localCallback");
        builder.localAuthorizationUrlPath("/auth");
        builder.clientCredentials("Aladdin", "open sesame");
        LinkedHashMap<String, String> bodyParams = new LinkedHashMap<String, String>();
        bodyParams.put("ice", "cream");
        bodyParams.put("pan", "cake");
        builder.customBodyParameters(bodyParams);
        this.minimalDancer = (AuthorizationCodeOAuthDancer)this.startDancer(builder);
        ((RequestHandler)this.localCallbackCaptor.getValue()).handleRequest(this.buildLocalCallbackRequestContext(), (HttpResponseReadyCallback)Mockito.mock(HttpResponseReadyCallback.class));
        ArgumentCaptor requestCaptor = ArgumentCaptor.forClass(HttpRequest.class);
        ((HttpClient)Mockito.verify((Object)this.httpClient)).sendAsync((HttpRequest)requestCaptor.capture(), (HttpRequestOptions)ArgumentMatchers.any(HttpRequestOptions.class));
        String requestBody = IOUtils.toString((InputStream)((HttpRequest)requestCaptor.getValue()).getEntity().getContent(), (Charset)StandardCharsets.UTF_8);
        MatcherAssert.assertThat((Object)requestBody, (Matcher)Matchers.containsString((String)"ice=cream"));
        MatcherAssert.assertThat((Object)requestBody, (Matcher)Matchers.containsString((String)"pan=cake"));
    }

    @Test
    public void authCodeRefreshTokenWithQueryParamsAndSeveralAdditionalHeadersAndParameters() throws Exception {
        OAuthAuthorizationCodeDancerBuilder builder = this.baseAuthCodeDancerbuilder();
        builder.tokenUrl("http://host/token");
        builder.authorizationUrl("http://host/auth");
        builder.clientCredentials("Aladdin", "openSesame");
        builder.externalCallbackUrl("http://localhost:8081/callback");
        MultiMap additionalRefreshTokenHeaders = new MultiMap();
        additionalRefreshTokenHeaders.put((Object)"additional_header", (Object)"header");
        additionalRefreshTokenHeaders.put((Object)"additional_header", (Object)"header2");
        builder.addAdditionalRefreshTokenRequestHeaders(additionalRefreshTokenHeaders);
        MultiMap additionalRefreshTokenParameters = new MultiMap();
        additionalRefreshTokenParameters.put((Object)"additional_parameter", (Object)"additionalParam");
        additionalRefreshTokenParameters.put((Object)"additional_parameter", (Object)"additionalParam2");
        builder.addAdditionalRefreshTokenRequestParameters(additionalRefreshTokenParameters);
        this.minimalDancer = (AuthorizationCodeOAuthDancer)this.startDancer(builder);
        this.minimalDancer.refreshToken(null, true);
        ArgumentCaptor requestCaptor = ArgumentCaptor.forClass(HttpRequest.class);
        ((HttpClient)Mockito.verify((Object)this.httpClient)).sendAsync((HttpRequest)requestCaptor.capture(), (HttpRequestOptions)ArgumentMatchers.any(HttpRequestOptions.class));
        MatcherAssert.assertThat((Object)((String)((HttpRequest)requestCaptor.getValue()).getQueryParams().get((Object)"client_id")), (Matcher)Matchers.is((Object)"Aladdin"));
        MatcherAssert.assertThat((Object)((String)((HttpRequest)requestCaptor.getValue()).getQueryParams().get((Object)"client_secret")), (Matcher)Matchers.is((Object)"openSesame"));
        MatcherAssert.assertThat((Object)((String)((HttpRequest)requestCaptor.getValue()).getQueryParams().get((Object)"grant_type")), (Matcher)Matchers.is((Object)"refresh_token"));
        MatcherAssert.assertThat((Object)((String)((HttpRequest)requestCaptor.getValue()).getQueryParams().get((Object)"refresh_token")), (Matcher)Matchers.is((Object)"refreshToken"));
        MatcherAssert.assertThat((Object)((String)((HttpRequest)requestCaptor.getValue()).getQueryParams().get((Object)"redirect_uri")), (Matcher)Matchers.is((Object)"http://localhost:8081/callback"));
        MatcherAssert.assertThat((Object)((HttpRequest)requestCaptor.getValue()).getQueryParams().getAll((Object)"additional_parameter").size(), (Matcher)Matchers.is((Object)2));
        MatcherAssert.assertThat((Object)((HttpRequest)requestCaptor.getValue()).getQueryParams().getAll((Object)"additional_parameter").contains("additionalParam"), (Matcher)Matchers.is((Object)true));
        MatcherAssert.assertThat((Object)((HttpRequest)requestCaptor.getValue()).getQueryParams().getAll((Object)"additional_parameter").contains("additionalParam2"), (Matcher)Matchers.is((Object)true));
        MatcherAssert.assertThat((Object)((HttpRequest)requestCaptor.getValue()).getHeaders().getAll((Object)"additional_header").size(), (Matcher)Matchers.is((Object)2));
        MatcherAssert.assertThat((Object)((HttpRequest)requestCaptor.getValue()).getHeaders().getAll((Object)"additional_header").contains("header"), (Matcher)Matchers.is((Object)true));
        MatcherAssert.assertThat((Object)((HttpRequest)requestCaptor.getValue()).getHeaders().getAll((Object)"additional_header").contains("header2"), (Matcher)Matchers.is((Object)true));
        String requestBody = IOUtils.toString((InputStream)((HttpRequest)requestCaptor.getValue()).getEntity().getContent(), (Charset)StandardCharsets.UTF_8);
        MatcherAssert.assertThat((Object)requestBody, (Matcher)Matchers.not((Matcher)Matchers.containsString((String)"grant_type=refresh_token")));
        MatcherAssert.assertThat((Object)requestBody, (Matcher)Matchers.not((Matcher)Matchers.containsString((String)"refresh_token=")));
        MatcherAssert.assertThat((Object)requestBody, (Matcher)Matchers.not((Matcher)Matchers.containsString((String)"client_secret=openSesame")));
        MatcherAssert.assertThat((Object)requestBody, (Matcher)Matchers.not((Matcher)Matchers.containsString((String)"client_id=Aladdin")));
    }

    @Test
    public void authCodeRefreshTokenWithQueryParamsAndNoRedirectUriParameter() throws Exception {
        OAuthAuthorizationCodeDancerBuilder builder = this.baseAuthCodeDancerbuilder();
        builder.tokenUrl("http://host/token");
        builder.authorizationUrl("http://host/auth");
        builder.clientCredentials("Aladdin", "openSesame");
        builder.includeRedirectUriInRefreshTokenRequest(false);
        this.minimalDancer = (AuthorizationCodeOAuthDancer)this.startDancer(builder);
        this.minimalDancer.refreshToken(null, true);
        ArgumentCaptor requestCaptor = ArgumentCaptor.forClass(HttpRequest.class);
        ((HttpClient)Mockito.verify((Object)this.httpClient)).sendAsync((HttpRequest)requestCaptor.capture(), (HttpRequestOptions)ArgumentMatchers.any(HttpRequestOptions.class));
        MatcherAssert.assertThat((Object)((String)((HttpRequest)requestCaptor.getValue()).getQueryParams().get((Object)"client_id")), (Matcher)Matchers.is((Object)"Aladdin"));
        MatcherAssert.assertThat((Object)((String)((HttpRequest)requestCaptor.getValue()).getQueryParams().get((Object)"client_secret")), (Matcher)Matchers.is((Object)"openSesame"));
        MatcherAssert.assertThat((Object)((String)((HttpRequest)requestCaptor.getValue()).getQueryParams().get((Object)"grant_type")), (Matcher)Matchers.is((Object)"refresh_token"));
        MatcherAssert.assertThat((Object)((String)((HttpRequest)requestCaptor.getValue()).getQueryParams().get((Object)"refresh_token")), (Matcher)Matchers.is((Object)"refreshToken"));
        MatcherAssert.assertThat((Object)((String)((HttpRequest)requestCaptor.getValue()).getQueryParams().get((Object)"redirect_uri")), (Matcher)Matchers.nullValue());
        String requestBody = IOUtils.toString((InputStream)((HttpRequest)requestCaptor.getValue()).getEntity().getContent(), (Charset)StandardCharsets.UTF_8);
        MatcherAssert.assertThat((Object)requestBody, (Matcher)Matchers.not((Matcher)Matchers.containsString((String)"grant_type=refresh_token")));
        MatcherAssert.assertThat((Object)requestBody, (Matcher)Matchers.not((Matcher)Matchers.containsString((String)"refresh_token=")));
        MatcherAssert.assertThat((Object)requestBody, (Matcher)Matchers.not((Matcher)Matchers.containsString((String)"client_secret=openSesame")));
        MatcherAssert.assertThat((Object)requestBody, (Matcher)Matchers.not((Matcher)Matchers.containsString((String)"client_id=Aladdin")));
    }

    @Test
    public void authCodeCredentialsAsQueryParams() throws Exception {
        OAuthAuthorizationCodeDancerBuilder builder = this.baseAuthCodeDancerbuilder();
        builder.tokenUrl("http://host/token");
        builder.authorizationUrl("http://host/auth");
        builder.localCallback(this.httpServer, "/localCallback");
        builder.localAuthorizationUrlPath("/auth");
        builder.clientCredentials("Aladdin", "openSesame");
        builder.withClientCredentialsIn(ClientCredentialsLocation.QUERY_PARAMS);
        this.minimalDancer = (AuthorizationCodeOAuthDancer)this.startDancer(builder);
        ((RequestHandler)this.localCallbackCaptor.getValue()).handleRequest(this.buildLocalCallbackRequestContext(), (HttpResponseReadyCallback)Mockito.mock(HttpResponseReadyCallback.class));
        ArgumentCaptor requestCaptor = ArgumentCaptor.forClass(HttpRequest.class);
        ((HttpClient)Mockito.verify((Object)this.httpClient)).sendAsync((HttpRequest)requestCaptor.capture(), (HttpRequestOptions)ArgumentMatchers.any(HttpRequestOptions.class));
        MatcherAssert.assertThat((Object)((String)((HttpRequest)requestCaptor.getValue()).getQueryParams().get((Object)"client_id")), (Matcher)Matchers.is((Object)"Aladdin"));
        MatcherAssert.assertThat((Object)((String)((HttpRequest)requestCaptor.getValue()).getQueryParams().get((Object)"client_secret")), (Matcher)Matchers.is((Object)"openSesame"));
        MatcherAssert.assertThat((Object)((HttpRequest)requestCaptor.getValue()).getHeaderNames(), (Matcher)Matchers.not((Matcher)Matchers.hasItem((Matcher)IsEqualIgnoringCase.equalToIgnoringCase((String)"Authorization"))));
        String requestBody = IOUtils.toString((InputStream)((HttpRequest)requestCaptor.getValue()).getEntity().getContent(), (Charset)StandardCharsets.UTF_8);
        MatcherAssert.assertThat((Object)requestBody, (Matcher)Matchers.containsString((String)"code=authCode"));
        MatcherAssert.assertThat((Object)requestBody, (Matcher)Matchers.containsString((String)"grant_type=authorization_code"));
        MatcherAssert.assertThat((Object)requestBody, (Matcher)Matchers.not((Matcher)Matchers.containsString((String)"client_secret=openSesame")));
        MatcherAssert.assertThat((Object)requestBody, (Matcher)Matchers.not((Matcher)Matchers.containsString((String)"client_id=Aladdin")));
    }

    @Override
    protected OAuthAuthorizationCodeDancerBuilder baseAuthCodeDancerbuilder() {
        return this.baseAuthCodeDancerbuilder((MuleExpressionLanguage)Mockito.mock(MuleExpressionLanguage.class));
    }

    protected OAuthAuthorizationCodeDancerBuilder baseAuthCodeDancerbuilder(MuleExpressionLanguage muleExpressionLanguage) {
        ResourceOwnerOAuthContext context = this.contextSupplier.get();
        HashMap<String, ResourceOwnerOAuthContext> tokensMap = new HashMap<String, ResourceOwnerOAuthContext>();
        tokensMap.put("default", context);
        DefaultOAuthAuthorizationCodeDancerBuilder builder = new DefaultOAuthAuthorizationCodeDancerBuilder((SchedulerService)new SimpleUnitTestSupportSchedulerService(), this.lockFactory, tokensMap, this.httpService, this.oAuthHttpClientFactory, muleExpressionLanguage);
        builder.clientCredentials("clientId", "clientSecret");
        return builder;
    }
}

