/*
 * Decompiled with CFR 0.152.
 */
package org.mule.runtime.test.oauth.authorizationcode;

import io.qameta.allure.Story;
import java.util.Collections;
import java.util.List;
import org.hamcrest.Matcher;
import org.hamcrest.MatcherAssert;
import org.hamcrest.Matchers;
import org.junit.Test;
import org.mockito.Mockito;
import org.mule.oauth.client.api.listener.AuthorizationCodeListener;
import org.mule.oauth.client.api.listener.OAuthStateListener;
import org.mule.oauth.client.api.state.ResourceOwnerOAuthContext;
import org.mule.oauth.client.internal.DefaultAuthorizationCodeOAuthDancer;
import org.mule.oauth.client.internal.config.DefaultAuthorizationCodeOAuthDancerConfig;
import org.mule.tck.junit4.AbstractMuleTestCase;

@Story(value="Authorization Code")
public class DefaultAuthorizationCodeOAuthDancerTestCase
extends AbstractMuleTestCase {
    @Test
    public void testListenerFromConfig() {
        DefaultAuthorizationCodeOAuthDancerConfig config = new DefaultAuthorizationCodeOAuthDancerConfig();
        AuthorizationCodeListener listener = new AuthorizationCodeListener(){};
        config.setListeners(Collections.singletonList(listener));
        TestAuthorizationCodeOAuthDancer dancer = new TestAuthorizationCodeOAuthDancer(config);
        MatcherAssert.assertThat(dancer.getListeners(), (Matcher)Matchers.hasSize((int)1));
        MatcherAssert.assertThat((Object)dancer.getListeners().get(0), (Matcher)Matchers.sameInstance((Object)listener));
        dancer.removeListener(listener);
        MatcherAssert.assertThat(dancer.getListeners(), (Matcher)Matchers.hasSize((int)0));
    }

    @Test
    public void testAddedListener() {
        DefaultAuthorizationCodeOAuthDancerConfig config = new DefaultAuthorizationCodeOAuthDancerConfig();
        TestAuthorizationCodeOAuthDancer dancer = new TestAuthorizationCodeOAuthDancer(config);
        AuthorizationCodeListener listener = new AuthorizationCodeListener(){};
        dancer.addListener(listener);
        MatcherAssert.assertThat(dancer.getListeners(), (Matcher)Matchers.hasSize((int)1));
        MatcherAssert.assertThat((Object)dancer.getListeners().get(0), (Matcher)Matchers.sameInstance((Object)listener));
        dancer.removeListener(listener);
        MatcherAssert.assertThat(dancer.getListeners(), (Matcher)Matchers.hasSize((int)0));
    }

    @Test
    public void testAddedListenerForResourceOwner() {
        DefaultAuthorizationCodeOAuthDancerConfig config = new DefaultAuthorizationCodeOAuthDancerConfig();
        TestAuthorizationCodeOAuthDancer dancer = new TestAuthorizationCodeOAuthDancer(config);
        AuthorizationCodeListener listener = new AuthorizationCodeListener(){};
        String resourceOwnerId = "an-owner";
        dancer.addListener(resourceOwnerId, listener);
        ResourceOwnerOAuthContext resourceOwnerOAuthContext = (ResourceOwnerOAuthContext)Mockito.mock(ResourceOwnerOAuthContext.class);
        Mockito.when((Object)resourceOwnerOAuthContext.getResourceOwnerId()).thenReturn((Object)resourceOwnerId);
        MatcherAssert.assertThat(dancer.getListeners(resourceOwnerOAuthContext), (Matcher)Matchers.hasSize((int)1));
        MatcherAssert.assertThat((Object)dancer.getListeners(resourceOwnerOAuthContext).get(0), (Matcher)Matchers.sameInstance((Object)listener));
        dancer.removeListener(listener);
        MatcherAssert.assertThat(dancer.getListeners(resourceOwnerOAuthContext), (Matcher)Matchers.hasSize((int)1));
        dancer.removeListener(resourceOwnerId, listener);
        MatcherAssert.assertThat(dancer.getListeners(resourceOwnerOAuthContext), (Matcher)Matchers.hasSize((int)0));
    }

    private static class TestAuthorizationCodeOAuthDancer
    extends DefaultAuthorizationCodeOAuthDancer {
        public TestAuthorizationCodeOAuthDancer(DefaultAuthorizationCodeOAuthDancerConfig config) {
            super(config);
        }

        public List<? extends OAuthStateListener> getListeners() {
            return super.getListenersToNotifyInvalidation(null);
        }

        public List<? extends OAuthStateListener> getListeners(ResourceOwnerOAuthContext resourceOwnerOAuthContext) {
            return super.getListenersToNotifyInvalidation(resourceOwnerOAuthContext);
        }
    }
}

