/*
 * Decompiled with CFR 0.152.
 */
package org.mule.connectivity.model.api;

import java.net.URI;
import java.net.URISyntaxException;
import java.util.List;
import org.apache.commons.lang3.StringUtils;
import org.mule.connectivity.exception.GenerationException;
import org.mule.connectivity.exception.UnsupportedMediaTypeException;
import org.mule.connectivity.model.MavenDependency;
import org.mule.connectivity.model.api.RestConnectAPIModel;
import org.mule.connectivity.model.api.builder.SmartConnectorModelBuilder;
import org.mule.connectivity.model.operation.SmartConnectorOperation;
import org.mule.connectivity.util.ParserUtils;
import org.raml.v2.api.model.v10.methods.Method;

public class SmartConnectorModel
extends RestConnectAPIModel<SmartConnectorOperation> {
    private final String projectDescription;
    private final URI baseUri;
    private final List<MavenDependency> dependencies;

    public SmartConnectorModel(SmartConnectorModelBuilder builder) throws GenerationException {
        super(builder);
        this.projectDescription = builder.getProjectDescription();
        this.baseUri = this.buildBaseUri();
        this.dependencies = builder.getDependencies();
    }

    private URI buildBaseUri() throws GenerationException {
        try {
            URI uri = new URI(this.getBaseUri());
            if (!uri.isAbsolute()) {
                return null;
            }
            return uri;
        }
        catch (URISyntaxException e) {
            throw new GenerationException("Invalid base URI.", e);
        }
    }

    @Override
    protected SmartConnectorOperation createOperation(Method method) throws UnsupportedMediaTypeException {
        return new SmartConnectorOperation(method);
    }

    @Override
    protected String getDefaultGroupId() {
        return "org.mule.modules.extensions";
    }

    @Override
    protected String getDefaultArtifactId() {
        return "mule-module-" + this.getModulePrefix();
    }

    public String getModulePrefix() {
        return ParserUtils.getXmlName(this.apiName);
    }

    public String getNamespace() {
        return "http://www.mulesoft.org/schema/mule/" + this.getModulePrefix();
    }

    public String getBasePath() {
        if (this.baseUri == null) {
            return null;
        }
        return this.baseUri.getPath();
    }

    public String getProtocol() {
        if (this.baseUri == null) {
            return null;
        }
        return this.baseUri.getScheme().toUpperCase();
    }

    public String getHost() {
        if (this.baseUri == null) {
            return null;
        }
        return this.baseUri.getHost();
    }

    public Integer getPort() {
        if (this.baseUri == null) {
            return null;
        }
        if (this.baseUri.getPort() != -1) {
            return this.baseUri.getPort();
        }
        switch (this.getProtocol()) {
            case "HTTP": {
                return 80;
            }
            case "HTTPS": {
                return 443;
            }
        }
        return null;
    }

    public List<MavenDependency> getDependencies() {
        return this.dependencies;
    }

    public String getProjectDescription() {
        if (!StringUtils.isBlank((CharSequence)this.projectDescription) && !StringUtils.isBlank((CharSequence)this.getApiDescription())) {
            return String.format("%s - %s", this.projectDescription, this.getApiDescription());
        }
        if (!StringUtils.isBlank((CharSequence)this.projectDescription)) {
            return this.projectDescription;
        }
        if (!StringUtils.isBlank((CharSequence)this.getApiDescription())) {
            return this.getApiDescription();
        }
        return null;
    }
}

