/*
 * Decompiled with CFR 0.152.
 */
package org.mule.connectivity.model.metadata.definition;

import org.mule.connectivity.model.metadata.definition.CustomTypeDefinition;
import org.mule.connectivity.model.metadata.definition.TypeDefinition;

public class SimpleTypeDefinition
implements TypeDefinition {
    private final String name;

    public SimpleTypeDefinition(String name) {
        this.name = name;
    }

    @Override
    public String getName() {
        return this.name;
    }

    @Override
    public String getMule4Type() {
        switch (this.name) {
            case "integer": {
                return "integer";
            }
            case "boolean": {
                return "boolean";
            }
            case "date": 
            case "datetime": 
            case "date-only": 
            case "datetime-only": {
                return "date";
            }
            case "time-only": {
                return "time";
            }
        }
        return "string";
    }

    @Override
    public String getJavaType() {
        switch (this.name) {
            case "integer": {
                return "Integer";
            }
            case "boolean": {
                return "Boolean";
            }
            case "number": {
                return "BigDecimal";
            }
            case "date": 
            case "datetime": 
            case "date-only": 
            case "datetime-only": {
                return "Date";
            }
            case "file": {
                return "File";
            }
            case "string": {
                return "String";
            }
        }
        throw new IllegalArgumentException("Invalid type value: " + this.name);
    }

    @Override
    public boolean isCustomType() {
        return false;
    }

    @Override
    public CustomTypeDefinition getCustomType() {
        return null;
    }
}

