/*
 * Decompiled with CFR 0.152.
 */
package org.mule.connectivity.model.operation;

import java.util.ArrayList;
import java.util.List;
import org.apache.commons.lang3.StringUtils;
import org.mule.connectivity.exception.UnsupportedMediaTypeException;
import org.mule.connectivity.model.metadata.MetadataModelFactory;
import org.mule.connectivity.model.operation.Operation;
import org.mule.connectivity.model.parameter.PropertyParameter;
import org.mule.connectivity.util.ParserUtils;
import org.raml.v2.api.model.v10.methods.Method;

public class SmartConnectorOperation
extends Operation {
    public SmartConnectorOperation(Method method) throws UnsupportedMediaTypeException {
        super(method);
        MetadataModelFactory metadataModelFactory = new MetadataModelFactory(method);
        this.inputMetaData = metadataModelFactory.constructInputMetadata(this.getName() + "-request-type");
        this.outputMetaData = metadataModelFactory.constructOutputMetadata(this.getName() + "-response-type");
    }

    public String getName() {
        return ParserUtils.getXmlName(this.canonicalName);
    }

    public String getQueryParametersDW() {
        return this.getParametersDW(this.queryParameters);
    }

    public String getUriParametersDW() {
        return this.getParametersDW(this.uriParameters);
    }

    public String getHeadersDW() {
        return this.getParametersDW(this.headers);
    }

    public boolean hasInputParameters() {
        return this.inputMetaData != null || !this.parameters.isEmpty();
    }

    public String getInputMetadataParameterName() {
        return this.getName() + "-request-data";
    }

    private String getParametersDW(List<PropertyParameter> parameters) {
        ArrayList<String> keys = new ArrayList<String>();
        for (PropertyParameter parameter : parameters) {
            keys.add(String.format("'%s': parameters['%s']", parameter.getName(), parameter.getXmlName()));
        }
        return String.format("#[ { %s } filter $ != null ]", StringUtils.join(keys, (String)","));
    }
}

