/*
 * Decompiled with CFR 0.152.
 */
package org.mule.connectivity.util;

import com.google.common.base.Function;
import com.google.common.collect.FluentIterable;
import com.google.common.collect.TreeTraverser;
import java.util.HashSet;
import java.util.List;
import javax.annotation.Nullable;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.mule.connectivity.exception.DuplicateOperationException;
import org.mule.connectivity.model.operation.Operation;
import org.raml.v2.api.model.v10.api.Api;
import org.raml.v2.api.model.v10.declarations.AnnotationRef;
import org.raml.v2.api.model.v10.methods.Method;
import org.raml.v2.api.model.v10.resources.Resource;

public class OperationMappingUtils {
    protected static final Logger logger = LogManager.getLogger(OperationMappingUtils.class);
    private static final TreeTraverser<Resource> TRAVERSER = new TreeTraverser<Resource>(){

        public Iterable<Resource> children(Resource root) {
            return root.resources();
        }
    };
    private static final String IGNORE_ANNOTATION = "ignored";

    public static List<Method> getMethods(Api api) {
        List resources = api.resources();
        return FluentIterable.from((Iterable)resources).transformAndConcat((Function)new Function<Resource, Iterable<Resource>>(){

            @Nullable
            public Iterable<Resource> apply(@Nullable Resource input) {
                return TRAVERSER.preOrderTraversal((Object)input);
            }
        }).transformAndConcat((Function)new Function<Resource, Iterable<Method>>(){

            @Nullable
            public Iterable<Method> apply(@Nullable Resource input) {
                return input.methods();
            }
        }).toList();
    }

    public static boolean isIgnored(Method method) {
        for (AnnotationRef annotationRef : method.annotations()) {
            if (!IGNORE_ANNOTATION.equals(annotationRef.annotation().name())) continue;
            return true;
        }
        return false;
    }

    public static void validateNoDuplicateOperations(List<? extends Operation> operations) throws DuplicateOperationException {
        HashSet<String> operationNames = new HashSet<String>();
        for (Operation operation : operations) {
            String operationName = operation.getCanonicalName();
            if (operationNames.contains(operationName)) {
                throw new DuplicateOperationException(operation.getFriendlyName());
            }
            operationNames.add(operationName);
        }
    }
}

