/*
 * Decompiled with CFR 0.152.
 */
package org.mule.connectivity.model;

import org.raml.v2.api.model.v10.methods.Method;

public enum HTTPMethod {
    GET,
    POST,
    PUT,
    PATCH,
    DELETE;


    public String getVerbName() {
        switch (this) {
            case GET: {
                return "GET";
            }
            case POST: {
                return "CREATE";
            }
            case PUT: 
            case PATCH: {
                return "UPDATE";
            }
            case DELETE: {
                return "DELETE";
            }
        }
        throw new IllegalArgumentException("Unsupported method.");
    }

    public boolean isAlwaysSingular() {
        return this.equals((Object)POST);
    }

    public static HTTPMethod fromMethod(Method method) {
        for (HTTPMethod httpMethod : HTTPMethod.values()) {
            if (!method.method().equalsIgnoreCase(httpMethod.name())) continue;
            return httpMethod;
        }
        throw new IllegalArgumentException("Action '" + method.displayName().value() + "' should be a get / post / put / patch / delete operation.");
    }
}

